/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.net.URI;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.LocalFileReference;

public abstract class AbstractFileReference
implements FileReference {
    @Override
    public final LocalFileReference toLocalReference() {
        if (this.isLocal()) {
            return (LocalFileReference)((Object)this);
        }
        throw new IllegalArgumentException("Not locally stored");
    }

    @Override
    public final HashFileReference toHashReference() {
        if (!this.isLocal()) {
            return (HashFileReference)((Object)this);
        }
        throw new IllegalArgumentException("Locally stored");
    }

    public abstract FileData<FileReference> getData();

    @Override
    public FileReference overwrite(ByteSource in) throws IOException {
        return this.getData().overwrite(in);
    }

    @Override
    public final boolean isExists() {
        return this.getData().isExists();
    }

    @Override
    public final boolean delete() {
        return this.getData().delete();
    }

    @Override
    public ByteSource asByteSource() {
        return this.getData().asByteSource();
    }

    @Override
    public long length() {
        return this.getData().length();
    }

    @Override
    public final URI getFileLocation() {
        return this.getData().getFileLocation();
    }

    @Override
    public final boolean isFileBacked() {
        return this.getData().isFileBacked();
    }
}

