/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import com.google.common.io.CharSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.time.Instant;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.GetOptions;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.FileStoreStatistics;
import uk.ac.warwick.util.files.impl.StatisticsRecordingByteSource;
import uk.ac.warwick.util.files.impl.StatisticsRecordingCharSource;

public abstract class AbstractBlobBackedFileData
implements FileData {
    private static final long TEMPURL_EXPIRY_SECS = 3600L;
    private final FileStoreStatistics statistics;
    private final BlobStore blobStore;
    private final String containerName;
    private final String blobName;
    protected final BlobBackedByteSource byteSource;

    protected AbstractBlobBackedFileData(FileStore fileStore, BlobStore blobStore, String containerName, String blobName) {
        this(fileStore.getStatistics(), blobStore, containerName, blobName);
    }

    protected AbstractBlobBackedFileData(FileStoreStatistics statistics, BlobStore blobStore, String containerName, String blobName) {
        this.statistics = statistics;
        this.blobStore = blobStore;
        this.containerName = containerName;
        this.blobName = blobName;
        this.byteSource = new BlobBackedByteSource();
    }

    @Override
    public BlobBackedByteSource asByteSource() {
        return this.byteSource;
    }

    @Override
    public long length() {
        return this.asByteSource().size();
    }

    @Override
    public final boolean isExists() {
        return !this.asByteSource().isEmpty();
    }

    @Override
    public final URI getFileLocation() {
        return this.blobStore.getContext().getSigner().signGetBlob(this.containerName, this.blobName, 3600L).getEndpoint();
    }

    @Override
    public final boolean isFileBacked() {
        return false;
    }

    @Override
    public boolean delete() {
        if (!this.isExists()) {
            return true;
        }
        this.statistics.timeSafe(() -> this.blobStore.removeBlob(this.containerName, this.blobName), this.statistics::referenceDeleted);
        this.asByteSource().invalidate();
        return true;
    }

    FileStoreStatistics getStatistics() {
        return this.statistics;
    }

    BlobStore getBlobStore() {
        return this.blobStore;
    }

    String getContainerName() {
        return this.containerName;
    }

    String getBlobName() {
        return this.blobName;
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        return this.blobName;
    }

    protected class BlobBackedCharSource
    extends StatisticsRecordingCharSource {
        private final Charset charset;
        private final BlobBackedByteSource byteSource;

        private BlobBackedCharSource(Charset charset, BlobBackedByteSource byteSource) {
            super(AbstractBlobBackedFileData.this.statistics);
            this.charset = (Charset)Preconditions.checkNotNull((Object)charset);
            this.byteSource = (BlobBackedByteSource)((Object)Preconditions.checkNotNull((Object)((Object)byteSource)));
        }

        public Reader openStream() throws IOException {
            return new InputStreamReader(this.byteSource.openStream(), this.charset);
        }

        @Override
        public String read() throws IOException {
            return new String(this.byteSource.read(), this.charset);
        }

        public boolean isEmpty() {
            return this.byteSource.isEmpty();
        }

        public String toString() {
            return this.byteSource.toString() + ".asCharSource(" + this.charset + ")";
        }
    }

    class BlobBackedByteSource
    extends StatisticsRecordingByteSource {
        protected final long offset;
        protected final long length;
        protected transient Blob blob;
        protected transient long totalLength;
        protected transient boolean payloadUsed;

        BlobBackedByteSource() {
            this(-1L, -1L, -1L);
        }

        BlobBackedByteSource(long offset, long length, long totalLength) {
            super(AbstractBlobBackedFileData.this.statistics);
            this.offset = offset;
            this.length = length;
            this.totalLength = totalLength;
        }

        protected void invalidate() {
            this.blob = null;
            this.totalLength = -1L;
            this.payloadUsed = false;
        }

        synchronized void refresh() {
            GetOptions options = this.offset >= 0L && this.length > 0L ? GetOptions.Builder.range((long)this.offset, (long)(this.offset + this.length - 1L)) : GetOptions.NONE;
            this.blob = AbstractBlobBackedFileData.this.statistics.timeSafe(() -> AbstractBlobBackedFileData.this.blobStore.getBlob(AbstractBlobBackedFileData.this.containerName, AbstractBlobBackedFileData.this.blobName, options), AbstractBlobBackedFileData.this.statistics::referenceOpened);
            if (this.totalLength < 0L) {
                this.totalLength = this.blob == null ? -1L : (this.offset < 0L || this.length <= 0L ? this.blob.getMetadata().getSize().longValue() : AbstractBlobBackedFileData.this.statistics.timeSafe(() -> AbstractBlobBackedFileData.this.blobStore.blobMetadata(AbstractBlobBackedFileData.this.containerName, AbstractBlobBackedFileData.this.blobName).getSize(), AbstractBlobBackedFileData.this.statistics::referenceOpened).longValue());
            }
            this.payloadUsed = false;
        }

        public synchronized InputStream openStream() throws IOException {
            if (this.blob == null || !this.blob.getPayload().isRepeatable() && this.payloadUsed) {
                this.refresh();
            }
            this.payloadUsed = true;
            return this.blob.getPayload().openStream();
        }

        public ByteSource slice(long offset, long length) {
            long actualOffset = offset;
            if (this.offset >= 0L && length > 0L) {
                actualOffset = this.offset + offset;
            }
            if (this.totalLength < 0L) {
                this.refresh();
            }
            return new BlobBackedByteSource(actualOffset, length, this.totalLength);
        }

        public synchronized boolean isEmpty() {
            if (this.blob == null) {
                this.refresh();
            }
            return this.blob == null;
        }

        public Optional<Long> sizeIfKnown() {
            if (this.length > 0L && this.totalLength > 0L) {
                if (this.offset + this.length > this.totalLength) {
                    return Optional.of((Object)(this.totalLength - this.offset));
                }
                return Optional.of((Object)this.length);
            }
            return Optional.fromNullable((Object)this.blob).transform(b -> b.getMetadata().getSize());
        }

        public synchronized long size() {
            if (this.length > 0L) {
                if (this.totalLength < 0L) {
                    this.refresh();
                }
                if (this.offset + this.length > this.totalLength) {
                    return this.totalLength - this.offset;
                }
                return this.length;
            }
            if (this.blob == null) {
                this.refresh();
            }
            if (this.blob == null) {
                return 0L;
            }
            return this.blob.getMetadata().getSize();
        }

        public synchronized Instant getLastModified() {
            if (this.blob == null) {
                this.refresh();
            }
            if (this.blob == null) {
                return null;
            }
            return this.blob.getMetadata().getLastModified().toInstant();
        }

        public CharSource asCharSource(Charset charset) {
            return new BlobBackedCharSource(charset, this);
        }

        public String toString() {
            return "BlobBackedByteSource.asByteSource(" + AbstractBlobBackedFileData.this.containerName + "/" + AbstractBlobBackedFileData.this.blobName + ")";
        }
    }
}

