/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import uk.ac.warwick.util.concurrency.TaskExecutionService;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.imageresize.ImageResizer;

public final class SingleThreadedImageResizer
implements ImageResizer {
    private final TaskExecutionService executionService = new TaskExecutionService(1);
    private final ConcurrentMap<String, Future<Long>> lengthRequests = new ConcurrentHashMap<String, Future<Long>>();
    private final ImageResizer delegate;

    public SingleThreadedImageResizer(ImageResizer resizer) {
        this.delegate = resizer;
    }

    @Override
    public long getResizedImageLength(final ByteSource source, final HashString hash, final ZonedDateTime lastModified, final int maxWidth, final int maxHeight, final ImageResizer.FileType fileType) throws IOException {
        String key = this.generateCacheKey(hash, maxWidth, maxHeight);
        try {
            Future future;
            if (this.lengthRequests.containsKey(key)) {
                future = (Future)this.lengthRequests.get(key);
            } else {
                future = this.executionService.submit((Callable)new Callable<Long>(){

                    @Override
                    public Long call() throws Exception {
                        return SingleThreadedImageResizer.this.delegate.getResizedImageLength(source, hash, lastModified, maxWidth, maxHeight, fileType);
                    }
                });
                this.lengthRequests.put(key, future);
            }
            long l = (Long)future.get();
            return l;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        finally {
            this.lengthRequests.remove(key);
        }
    }

    @Override
    public void renderResized(ByteSource source, HashString hash, ZonedDateTime lastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
        try {
            this.executionService.submit(() -> {
                this.delegate.renderResized(source, hash, lastModified, out, maxWidth, maxHeight, fileType);
                return null;
            }).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String generateCacheKey(HashString hash, int maxWidth, int maxHeight) {
        String referencePath = hash.toString();
        return referencePath + "@" + maxWidth + "x" + maxHeight;
    }
}

