/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class LazyCreationFileOutputStream
extends OutputStream {
    private FileOutputStream delegate;
    private final File file;

    public LazyCreationFileOutputStream(File f) {
        this.file = f;
    }

    @Override
    public void write(int b) throws IOException {
        this.getDelegate().write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.getDelegate().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDelegate().write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        if (this.delegate != null) {
            this.delegate.flush();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    private FileOutputStream getDelegate() throws FileNotFoundException {
        if (this.delegate == null) {
            this.delegate = new FileOutputStream(this.file);
        }
        return this.delegate;
    }
}

