/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import uk.ac.warwick.util.files.hash.HashString;

public interface ImageResizer {
    public void renderResized(ByteSource var1, HashString var2, ZonedDateTime var3, OutputStream var4, int var5, int var6, FileType var7) throws IOException;

    public long getResizedImageLength(ByteSource var1, HashString var2, ZonedDateTime var3, int var4, int var5, FileType var6) throws IOException;

    public static enum Orientation {
        Normal(false, 0),
        Mirrored(true, 0),
        Rotate180(false, 180),
        MirroredVertically(true, 180),
        MirroredRotate270(true, 270),
        Rotate90(false, 90),
        MirroredRotate90(true, 90),
        Rotate270(false, 270);

        public final boolean mirrored;
        public final int rotationDegrees;

        private Orientation(boolean mirrored, int rotationDegrees) {
            this.mirrored = mirrored;
            this.rotationDegrees = rotationDegrees;
        }

        static Orientation fromExifOrientationValue(int value) {
            switch (value) {
                case 2: {
                    return Mirrored;
                }
                case 3: {
                    return Rotate180;
                }
                case 4: {
                    return MirroredVertically;
                }
                case 5: {
                    return MirroredRotate270;
                }
                case 6: {
                    return Rotate90;
                }
                case 7: {
                    return MirroredRotate90;
                }
                case 8: {
                    return Rotate270;
                }
            }
            return Normal;
        }
    }

    public static enum FileType {
        png,
        gif,
        jpg,
        webp;

    }
}

