/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.options.GetOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.hash.impl.BlobStoreBackedHashResolver;
import uk.ac.warwick.util.files.impl.CachingBlobBackedHashFileReference;

public class CachingBlobStoreBackedHashResolver
implements FileHashResolver,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingBlobStoreBackedHashResolver.class);
    private final BlobStoreBackedHashResolver delegate;
    private LoadingCache<String, Blob> cache;
    private long maximumSizeInBytes;

    public CachingBlobStoreBackedHashResolver(BlobStoreBackedHashResolver delegate) {
        this.delegate = delegate;
    }

    public long getMaximumSizeInBytes() {
        return this.maximumSizeInBytes;
    }

    public void setMaximumSizeInBytes(long maximumSizeInBytes) {
        this.maximumSizeInBytes = maximumSizeInBytes;
    }

    public void setMaximumSizeAsPercentage(int percentage) {
        Assert.isTrue((percentage > 0 && percentage < 100 ? 1 : 0) != 0, (String)"Percentage must be > 0 and < 100");
        this.maximumSizeInBytes = Runtime.getRuntime().maxMemory() * (long)percentage / 100L;
    }

    public void afterPropertiesSet() {
        Assert.isTrue((this.maximumSizeInBytes > 0L ? 1 : 0) != 0, (String)"Maximum cache size should be set using either setMaximumSizeInBytes or setMaximumSizeAsPercentage");
        LOGGER.info(String.format("Initialising a Caffeine cache with a maximum size of %d bytes", this.maximumSizeInBytes));
        this.cache = Caffeine.newBuilder().weigher((k, b) -> {
            long length = b.getMetadata().getContentMetadata().getContentLength();
            if (length > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)length;
        }).maximumWeight(this.maximumSizeInBytes).recordStats().build(key -> {
            Blob blob = this.delegate.getBlobStore().getBlob(this.delegate.getContainerName(), key, GetOptions.NONE);
            if (blob != null) {
                try (InputStream in = blob.getPayload().openStream();){
                    Blob cacheableBlob = this.delegate.getBlobStore().blobBuilder(key).payload(ByteStreams.toByteArray((InputStream)in)).contentDisposition(blob.getMetadata().getContentMetadata().getContentDisposition()).contentLength(blob.getMetadata().getContentMetadata().getContentLength().longValue()).contentType(blob.getMetadata().getContentMetadata().getContentType()).contentEncoding(blob.getMetadata().getContentMetadata().getContentEncoding()).contentLanguage(blob.getMetadata().getContentMetadata().getContentLanguage()).contentMD5(blob.getMetadata().getContentMetadata().getContentMD5AsHashCode()).cacheControl(blob.getMetadata().getContentMetadata().getCacheControl()).expires(blob.getMetadata().getContentMetadata().getExpires()).userMetadata(blob.getMetadata().getUserMetadata()).build();
                    cacheableBlob.getMetadata().setSize(blob.getMetadata().getSize());
                    Blob blob2 = cacheableBlob;
                    return blob2;
                }
            }
            return null;
        });
    }

    @Override
    public boolean exists(HashString hashString) {
        if (this.cache.getIfPresent((Object)hashString.getHash()) != null) {
            return true;
        }
        return this.delegate.exists(hashString);
    }

    @Override
    public HashFileReference lookupByHash(HashFileStore store, HashString fileHash, boolean storeNewHash) {
        return new CachingBlobBackedHashFileReference(this.delegate.lookupByHash(store, fileHash, storeNewHash), this.cache);
    }

    @Override
    public void removeHash(HashFileReference reference) {
        throw new UnsupportedOperationException("Refused to remove hash ");
    }

    @Override
    public HashString generateHash(InputStream is) throws IOException {
        return this.delegate.generateHash(is);
    }

    public long getCacheEstimatedSize() {
        return this.cache.estimatedSize();
    }

    public long getCacheCurrentSize() {
        return ((Policy.Eviction)this.cache.policy().eviction().get()).weightedSize().getAsLong();
    }

    public CacheStats getCacheStats() {
        return this.cache.stats();
    }

    Cache<String, Blob> getCache() {
        return this.cache;
    }
}

