/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files;

import java.io.IOException;
import java.io.Serializable;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface FileStoreStatistics
extends Serializable {
    public boolean isStatisticsEnabled();

    default public void time(FileStoreOperation operation, Consumer<Long> statisticsConsumer) throws IOException {
        if (!this.isStatisticsEnabled()) {
            operation.run();
        } else {
            long started = System.currentTimeMillis();
            operation.run();
            statisticsConsumer.accept(System.currentTimeMillis() - started);
        }
    }

    default public <T> T time(FileStoreSupplier<T> supplier, Consumer<Long> statisticsConsumer) throws IOException {
        if (!this.isStatisticsEnabled()) {
            return supplier.get();
        }
        long started = System.currentTimeMillis();
        T result = supplier.get();
        statisticsConsumer.accept(System.currentTimeMillis() - started);
        return result;
    }

    default public void timeSafe(Runnable operation, Consumer<Long> statisticsConsumer) {
        try {
            this.time(operation::run, statisticsConsumer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    default public <T> T timeSafe(Supplier<T> supplier, Consumer<Long> statisticsConsumer) {
        try {
            return (T)this.time(supplier::get, statisticsConsumer);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public void referenceOpened(long var1);

    public void referenceRead(long var1);

    public void referenceWritten(long var1);

    public void referenceDeleted(long var1);

    public void traversed(long var1);

    public void clear();

    @FunctionalInterface
    public static interface FileStoreSupplier<T> {
        public T get() throws IOException;
    }

    @FunctionalInterface
    public static interface FileStoreOperation {
        public void run() throws IOException;
    }
}

