/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.ByteArrayInputStream;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.io.Payload;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.BlobBackedHashFileReference;

public class BlobBackedHashFileReferenceTest {
    private final Mockery m = new JUnit4Mockery();
    private final HashFileStore fileStore = (HashFileStore)this.m.mock(HashFileStore.class);
    private final BlobStore blobStore = (BlobStore)this.m.mock(BlobStore.class);
    private final String containerName = "uk.ac.warwick.sbr.files";
    private final HashString hash = new HashString("files", "62139898312baed7981327ab9812f37");
    private BlobBackedHashFileReference ref;

    @Before
    public void setup() throws Exception {
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashFileStore)this.allowing(BlobBackedHashFileReferenceTest.this.fileStore)).getStatistics();
                this.will(1.returnValue((Object)new DefaultFileStoreStatistics((FileStore)BlobBackedHashFileReferenceTest.this.fileStore)));
            }
        });
        this.ref = new BlobBackedHashFileReference(this.fileStore, this.blobStore, "uk.ac.warwick.sbr.files", this.hash);
    }

    @Test
    public void lazyBlob() throws Exception {
        final Blob blob = (Blob)this.m.mock(Blob.class);
        final MutableBlobMetadata metadata = (MutableBlobMetadata)this.m.mock(MutableBlobMetadata.class);
        final Payload payload = (Payload)this.m.mock(Payload.class);
        Assert.assertFalse((boolean)this.ref.isLocal());
        Assert.assertFalse((boolean)this.ref.isFileBacked());
        Assert.assertEquals((Object)this.hash, (Object)this.ref.getHash());
        Assert.assertNull((Object)this.ref.getPath());
        Assert.assertNotNull((Object)this.ref.toString());
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((BlobStore)this.one(BlobBackedHashFileReferenceTest.this.blobStore)).getBlob("uk.ac.warwick.sbr.files", BlobBackedHashFileReferenceTest.this.hash.getHash(), GetOptions.NONE);
                this.will(2.returnValue((Object)blob));
                ((Blob)this.allowing(blob)).getMetadata();
                this.will(2.returnValue((Object)metadata));
                ((MutableBlobMetadata)this.allowing(metadata)).getSize();
                this.will(2.returnValue((Object)12345L));
                ((Blob)this.exactly(2).of((Object)blob)).getPayload();
                this.will(2.returnValue((Object)payload));
                ((Payload)this.allowing(payload)).isRepeatable();
                this.will(2.returnValue((Object)false));
                ((Payload)this.one(payload)).openStream();
                this.will(2.returnValue((Object)new ByteArrayInputStream(new byte[0])));
            }
        });
        Assert.assertTrue((boolean)this.ref.isExists());
        Assert.assertEquals((long)12345L, (long)this.ref.length());
        Assert.assertFalse((boolean)this.ref.asByteSource().isEmpty());
        Assert.assertNotNull((Object)this.ref.asByteSource().openStream());
        Assert.assertEquals((long)12345L, (long)this.ref.asByteSource().size());
        this.m.assertIsSatisfied();
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((BlobStore)this.one(BlobBackedHashFileReferenceTest.this.blobStore)).getBlob("uk.ac.warwick.sbr.files", BlobBackedHashFileReferenceTest.this.hash.getHash(), GetOptions.NONE);
                this.will(3.returnValue((Object)blob));
                ((Blob)this.exactly(2).of((Object)blob)).getPayload();
                this.will(3.returnValue((Object)payload));
                ((Payload)this.allowing(payload)).isRepeatable();
                this.will(3.returnValue((Object)false));
                ((Payload)this.one(payload)).openStream();
                this.will(3.returnValue((Object)new ByteArrayInputStream(new byte[0])));
            }
        });
        Assert.assertNotNull((Object)this.ref.asByteSource().openStream());
        this.m.assertIsSatisfied();
        ByteSource slicedByteSource = this.ref.asByteSource().slice(10L, 20L);
        final Blob slicedBlob = (Blob)this.m.mock(Blob.class, "slicedBlob");
        final Payload slicedBlobPayload = (Payload)this.m.mock(Payload.class, "slicedBlobPayload");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((BlobStore)this.one(BlobBackedHashFileReferenceTest.this.blobStore)).getBlob("uk.ac.warwick.sbr.files", BlobBackedHashFileReferenceTest.this.hash.getHash(), GetOptions.Builder.range((long)10L, (long)29L));
                this.will(4.returnValue((Object)slicedBlob));
                ((Blob)this.exactly(2).of((Object)slicedBlob)).getPayload();
                this.will(4.returnValue((Object)slicedBlobPayload));
                ((Payload)this.allowing(slicedBlobPayload)).isRepeatable();
                this.will(4.returnValue((Object)false));
                ((Payload)this.one(slicedBlobPayload)).openStream();
                this.will(4.returnValue((Object)new ByteArrayInputStream(new byte[0])));
            }
        });
        Assert.assertFalse((boolean)slicedByteSource.isEmpty());
        Assert.assertNotNull((Object)slicedByteSource.openStream());
        Assert.assertEquals((long)20L, (long)slicedByteSource.size());
        this.m.assertIsSatisfied();
    }
}

