/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.base.Charsets;
import com.google.common.io.CharSink;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.time.LocalDateTime;
import java.util.Collections;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Description;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.api.Action;
import org.jmock.api.Invocation;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4FileBasedTest;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashInfoImpl;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.StaticFileReferenceCreationStrategy;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.hash.impl.BlobStoreBackedHashResolver;
import uk.ac.warwick.util.files.hash.impl.SHAFileHasher;
import uk.ac.warwick.util.files.impl.BlobStoreFileStore;

public class BlobBackedHashFileReferenceLargeStreamsTest
extends AbstractJUnit4FileBasedTest {
    private static final String CONTAINER_PREFIX = "uk.ac.warwick.util.";
    private final Mockery m = new JUnit4Mockery();
    private final MaintenanceModeFlags flags = () -> false;
    private final HashInfoDAO sbd = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
    private final BlobStoreContext blobStoreContext = (BlobStoreContext)ContextBuilder.newBuilder((ApiMetadata)new TransientApiMetadata()).modules(Collections.singleton(new SLF4JLoggingModule())).buildView(BlobStoreContext.class);
    private final FileHashResolver defaultResolver = new BlobStoreBackedHashResolver(this.blobStoreContext, "uk.ac.warwick.util.", "default", (FileHasher)new SHAFileHasher(), this.sbd, this.flags);
    private final BlobStoreFileStore fileStore = new BlobStoreFileStore(Collections.singletonMap("default", this.defaultResolver), (FileReferenceCreationStrategy)StaticFileReferenceCreationStrategy.hash(), this.blobStoreContext, "uk.ac.warwick.util.");

    @Before
    public void setup() {
        this.blobStoreContext.getBlobStore().createContainerInLocation(null, "uk.ac.warwick.util.temp");
        this.blobStoreContext.getBlobStore().createContainerInLocation(null, "uk.ac.warwick.util.default");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashInfoDAO)this.allowing(BlobBackedHashFileReferenceLargeStreamsTest.this.sbd)).getHashByIdWithoutFlush((String)this.with(1.any(String.class)));
                this.will(new Action(){

                    public void describeTo(Description description) {
                        description.appendText("return valid HashInfo");
                    }

                    public Object invoke(Invocation invocation) throws Throwable {
                        String hash = invocation.getParameter(0).toString();
                        return new HashInfoImpl(new HashString(hash), LocalDateTime.now(), Long.valueOf(0L));
                    }
                });
            }
        });
    }

    @After
    public void shutdown() {
        this.blobStoreContext.close();
    }

    @Test
    @Ignore(value="Flappy")
    public void copyLargeBlobsWithStreams() throws Exception {
        File file = File.createTempFile("large", ".file", root);
        CharSink cs = Files.asCharSink((File)file, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[]{FileWriteMode.APPEND});
        for (int i = 0; i < 51; ++i) {
            cs.write((CharSequence)RandomStringUtils.randomAscii((int)0x100000));
        }
        Assert.assertEquals((long)0x3300000L, (long)file.length());
        LocalFileReference localRef = this.fileStore.storeLocalReference(new Storeable(){

            public String getPath() {
                return "/local-slo";
            }

            public HashString getHash() {
                return null;
            }

            public Storeable.StorageStrategy getStrategy() {
                return new Storeable.StorageStrategy(){

                    public String getRootPath() {
                        return "temp";
                    }

                    public Storeable.StorageStrategy.MissingContentStrategy getMissingContentStrategy() {
                        return Storeable.StorageStrategy.MissingContentStrategy.Local;
                    }

                    public String getDefaultHashStore() {
                        return null;
                    }

                    public boolean isSupportsLocalReferences() {
                        return true;
                    }
                };
            }
        }, Files.asByteSource((File)file));
        Assert.assertTrue((boolean)localRef.isExists());
        Assert.assertEquals((long)file.length(), (long)localRef.length());
        Thread.sleep(1000L);
        HashFileReference hashRef = this.fileStore.storeHashReference(localRef.asByteSource(), "default");
        Assert.assertTrue((boolean)hashRef.isExists());
        Assert.assertEquals((long)file.length(), (long)hashRef.length());
    }
}

