/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Collections;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.AbstractJUnit4FileBasedTest;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.LocalFileStore;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.hash.impl.BlobStoreBackedHashResolver;
import uk.ac.warwick.util.files.hash.impl.SHAFileHasher;
import uk.ac.warwick.util.files.imageresize.CachingImageResizer;
import uk.ac.warwick.util.files.imageresize.ImageResizer;
import uk.ac.warwick.util.files.impl.BlobStoreFileStore;
import uk.ac.warwick.util.files.impl.FileBackedHashFileReference;

public class CachingImageResizerTest
extends AbstractJUnit4FileBasedTest {
    private static final String CONTAINER_PREFIX = "uk.ac.warwick.sbr.";
    private final Mockery m = new JUnit4Mockery();
    private final FileHasher hasher = new SHAFileHasher();
    private final HashInfoDAO dao = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
    private final BlobStoreContext blobStoreContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"transient").buildView(BlobStoreContext.class);
    private final BlobStoreBackedHashResolver resolver = new BlobStoreBackedHashResolver(this.blobStoreContext, "uk.ac.warwick.sbr.", "resized-images", this.hasher, this.dao, () -> false);
    private final FileReferenceCreationStrategy strategy = (FileReferenceCreationStrategy)this.m.mock(FileReferenceCreationStrategy.class);
    private final Storeable.StorageStrategy storageStrategy = (Storeable.StorageStrategy)this.m.mock(Storeable.StorageStrategy.class);
    private final BlobStoreFileStore fileStore = new BlobStoreFileStore(Collections.singletonMap("resized-images", this.resolver), this.strategy, this.blobStoreContext, "uk.ac.warwick.sbr.");
    private final ZonedDateTime now = ZonedDateTime.now();
    private File contentRoot;
    private CachingImageResizer.FileStoreScaledImageCache cache;

    @Before
    public void createCache() throws Exception {
        this.contentRoot = new File(CachingImageResizerTest.getRoot(), "content");
        this.contentRoot.mkdirs();
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(CachingImageResizerTest.this.dao);
                ((Storeable.StorageStrategy)this.allowing(CachingImageResizerTest.this.storageStrategy)).getRootPath();
                this.will(1.returnValue((Object)"resized-images"));
            }
        });
        this.resolver.afterPropertiesSet();
        this.cache = new CachingImageResizer.FileStoreScaledImageCache((LocalFileStore)this.fileStore, this.storageStrategy);
    }

    @After
    public void shutdown() {
        FileUtils.recursiveDelete((File)this.contentRoot);
        this.blobStoreContext.close();
    }

    @Test
    public void renderResized() throws Exception {
        int i;
        ImageResizer dummyResizer = new ImageResizer(){

            public void renderResized(ByteSource in, HashString hash, ZonedDateTime lastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                byte[] input = FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg"));
                out.write(input);
            }

            public long getResizedImageLength(ByteSource in, HashString hash, ZonedDateTime lastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                return FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg")).length;
            }
        };
        CachingImageResizer resizer = new CachingImageResizer(dummyResizer, (CachingImageResizer.ImageCache)this.cache);
        FileReference sourceFile = this.file("/test/test.jpg");
        byte[] input = FileCopyUtils.copyToByteArray((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/tallThinSample.jpg"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        Assert.assertFalse((boolean)this.cache.contains(sourceFile.getHash(), this.now, 10, 10));
        resizer.renderResized(sourceFile.asByteSource(), sourceFile.getHash(), this.now, (OutputStream)bos, 10, 10, ImageResizer.FileType.jpg);
        byte[] result = bos.toByteArray();
        Assert.assertEquals((long)input.length, (long)result.length);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((long)input[i], (long)result[i]);
        }
        Assert.assertTrue((boolean)this.cache.contains(sourceFile.getHash(), this.now.minusHours(1L), 10, 10));
        bos = new ByteArrayOutputStream(input.length);
        resizer.renderResized(sourceFile.asByteSource(), sourceFile.getHash(), this.now.minusHours(1L), (OutputStream)bos, 10, 10, ImageResizer.FileType.jpg);
        result = bos.toByteArray();
        Assert.assertEquals((long)input.length, (long)result.length);
        for (i = 0; i < result.length; ++i) {
            Assert.assertEquals((long)input[i], (long)result[i]);
        }
    }

    @Test
    public void getResizedImageLength() throws Exception {
        ImageResizer dummyResizer = new ImageResizer(){

            public void renderResized(ByteSource in, HashString hash, ZonedDateTime lastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                byte[] input = FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg"));
                out.write(input);
            }

            public long getResizedImageLength(ByteSource in, HashString hash, ZonedDateTime lastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                return FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg")).length;
            }
        };
        CachingImageResizer resizer = new CachingImageResizer(dummyResizer, (CachingImageResizer.ImageCache)this.cache);
        FileReference sourceFile = this.file("/test/test.jpg");
        Assert.assertEquals((long)32992L, (long)resizer.getResizedImageLength(sourceFile.asByteSource(), sourceFile.getHash(), this.now, 10, 10, ImageResizer.FileType.jpg));
    }

    @Test
    public void scaledImageCacheContains() throws IOException, InterruptedException {
        FileReference nosuch = this.file("/ab/cd/ef");
        Assert.assertFalse((boolean)this.cache.contains(nosuch.getHash(), this.now.minusHours(1L), 10, 10));
        FileReference doesExist = this.file("/ab/cd/ef");
        this.fileStore.getForPath(this.storageStrategy, "abcdef@10x10").overwrite(ByteSource.wrap((byte[])"something".getBytes()));
        Assert.assertTrue((boolean)this.cache.contains(doesExist.getHash(), this.now.minusHours(1L), 10, 10));
        Assert.assertFalse((boolean)this.cache.contains(doesExist.getHash(), this.now.minusHours(1L), 20, 20));
    }

    @Test
    public void scaledImageCacheStaleEntry() throws InterruptedException, IOException {
        ZonedDateTime lastModified = this.now.plusHours(1L);
        this.fileStore.getForPath(this.storageStrategy, "abcdef@10x10").overwrite(ByteSource.wrap((byte[])"something".getBytes()));
        FileReference doesExist = this.file("/ab/cd/ef");
        File realFile = new File(doesExist.getFileLocation().getPath());
        realFile.getParentFile().mkdirs();
        realFile.createNewFile();
        Assert.assertFalse((boolean)this.cache.contains(doesExist.getHash(), lastModified, 10, 10));
    }

    private FileReference file(String path) throws IOException {
        File f = new File(this.contentRoot, path);
        FileBackedHashFileReference ref = new FileBackedHashFileReference((HashFileStore)this.fileStore, f, new HashString("abcdef"));
        return ref;
    }

    @Test
    public void serveFromCache() throws IOException {
        ByteSource in = Files.asByteSource((File)new File(((Object)((Object)this)).getClass().getResource("/tallThinSample.jpg").getFile()));
        this.fileStore.getForPath(this.storageStrategy, "abcdef@10x10").overwrite(in);
        FileReference original = this.file("/test.jpg");
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)in.size());
        this.cache.serveFromCache(original.getHash(), this.now, (OutputStream)bos, 10, 10);
        byte[] result = bos.toByteArray();
        Assert.assertEquals((long)in.size(), (long)result.length);
        byte[] input = in.read();
        for (int i = 0; i < result.length; ++i) {
            Assert.assertEquals((long)input[i], (long)result[i]);
        }
    }

    @Test
    public void cacheAndServe() throws IOException {
        ImageResizer dummyResizer = new ImageResizer(){

            public void renderResized(ByteSource in, HashString hash, ZonedDateTime lastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                byte[] input = FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg"));
                out.write(input);
            }

            public long getResizedImageLength(ByteSource in, HashString hash, ZonedDateTime lastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                return FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg")).length;
            }
        };
        FileReference sourceFile = this.file("/test/test.jpg");
        byte[] input = FileCopyUtils.copyToByteArray((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/tallThinSample.jpg"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        this.cache.cacheAndServe(sourceFile.asByteSource(), sourceFile.getHash(), this.now, (OutputStream)bos, 10, 10, ImageResizer.FileType.jpg, dummyResizer);
        byte[] result = bos.toByteArray();
        Assert.assertEquals((long)input.length, (long)result.length);
        for (int i = 0; i < result.length; ++i) {
            Assert.assertEquals((long)input[i], (long)result[i]);
        }
        Assert.assertTrue((boolean)this.cache.contains(sourceFile.getHash(), this.now.minusHours(1L), 10, 10));
    }

    @Test
    public void getFileSize() throws Exception {
        ImageResizer dummyResizer = new ImageResizer(){

            public void renderResized(ByteSource in, HashString hash, ZonedDateTime lastModified, OutputStream out, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                byte[] input = FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg"));
                out.write(input);
            }

            public long getResizedImageLength(ByteSource in, HashString hash, ZonedDateTime lastModified, int maxWidth, int maxHeight, ImageResizer.FileType fileType) throws IOException {
                return FileCopyUtils.copyToByteArray((InputStream)this.getClass().getResourceAsStream("/tallThinSample.jpg")).length;
            }
        };
        FileReference sourceFile = this.file("/test/test.jpg");
        Assert.assertEquals((long)32992L, (long)this.cache.getFileSize(sourceFile.asByteSource(), sourceFile.getHash(), this.now, 10, 10, ImageResizer.FileType.jpg, dummyResizer));
        byte[] input = FileCopyUtils.copyToByteArray((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/tallThinSample.jpg"));
        ByteArrayOutputStream bos = new ByteArrayOutputStream(input.length);
        this.cache.cacheAndServe(sourceFile.asByteSource(), sourceFile.getHash(), this.now, (OutputStream)bos, 10, 10, ImageResizer.FileType.jpg, dummyResizer);
        Assert.assertEquals((long)32992L, (long)this.cache.getFileSize(sourceFile.asByteSource(), sourceFile.getHash(), this.now, 10, 10, ImageResizer.FileType.jpg, dummyResizer));
    }
}

