/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import org.apache.commons.io.FilenameUtils;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.AbstractJUnit4FileBasedTest;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.hash.impl.FileSystemBackedHashResolver;

public final class FileSystemBackedHashResolverTest
extends AbstractJUnit4FileBasedTest {
    private final Mockery m = new JUnit4Mockery();
    private final FileHasher hasher = (FileHasher)this.m.mock(FileHasher.class);
    private final HashFileStore store = (HashFileStore)this.m.mock(HashFileStore.class);
    private final MaintenanceModeFlags flags = new MaintenanceModeFlags(){

        public boolean isInMaintenanceMode() {
            return false;
        }
    };
    private FileSystemBackedHashResolver resolver;
    private HashInfoDAO dao;

    @Before
    public void setup() {
        this.dao = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashFileStore)this.allowing(FileSystemBackedHashResolverTest.this.store)).getStatistics();
                this.will(2.returnValue((Object)new DefaultFileStoreStatistics((FileStore)FileSystemBackedHashResolverTest.this.store)));
            }
        });
        this.resolver = new FileSystemBackedHashResolver(this.hasher, "html", root, this.dao, this.flags);
    }

    @Test(expected=IllegalArgumentException.class)
    public void hashNotBelongingToMe() {
        HashString hash = new HashString("tiftof");
        this.resolver.lookupByHash(this.store, hash, true);
    }

    @Test
    public void lookupByHashDefault() throws Exception {
        this.resolver = new FileSystemBackedHashResolver(this.hasher, "default", root, this.dao, this.flags);
        String hash = "abcdefghijklmn";
        final HashString hashString = new HashString("abcdefghijklmn");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashInfoDAO)this.oneOf(FileSystemBackedHashResolverTest.this.dao)).getHashByIdWithoutFlush(hashString.toString());
                this.will(3.returnValue(null));
                ((HashInfoDAO)this.oneOf(FileSystemBackedHashResolverTest.this.dao)).hashCreated(hashString, 0L);
            }
        });
        HashFileReference reference = this.resolver.lookupByHash(this.store, hashString, true);
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)reference.getHash().toString());
    }

    @Test
    public void lookupByHash() throws Exception {
        HashString hash = new HashString("html", "ABCdef_-12345__6--7890&&abcdef1234567890&&abcdef1234567890");
        String expectedPath = FilenameUtils.separatorsToSystem((String)"ab/cd/ef/_-/12/345__6--7890__abcdef1234567890__abcdef1234567890.data");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashInfoDAO)this.oneOf(FileSystemBackedHashResolverTest.this.dao)).getHashByIdWithoutFlush("html/abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890");
                this.will(4.returnValue(null));
                ((HashInfoDAO)this.oneOf(FileSystemBackedHashResolverTest.this.dao)).hashCreated(new HashString("html/abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890"), 0L);
            }
        });
        File expectedFile = new File(root, expectedPath);
        HashFileReference reference = this.resolver.lookupByHash(this.store, hash, true);
        Assert.assertNotNull((Object)reference);
        Assert.assertEquals((Object)hash, (Object)reference.getHash());
        Assert.assertFalse((boolean)reference.isExists());
        Assert.assertTrue((boolean)reference.isFileBacked());
        Assert.assertEquals((Object)expectedFile.getAbsolutePath(), (Object)reference.getFileLocation().getPath());
        expectedFile.getParentFile().mkdirs();
        Assert.assertTrue((boolean)expectedFile.createNewFile());
        Assert.assertEquals((Object)hash, (Object)reference.getHash());
        Assert.assertTrue((boolean)reference.isExists());
        Assert.assertTrue((boolean)reference.isFileBacked());
        Assert.assertEquals((Object)expectedFile.getAbsolutePath(), (Object)reference.getFileLocation().getPath());
    }

    @Test
    public void generateHash() throws Exception {
        String hash = "abcdef";
        final ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileHasher)this.oneOf(FileSystemBackedHashResolverTest.this.hasher)).hash(is);
                this.will(5.returnValue((Object)"abcdef"));
            }
        });
        HashString generateHash = this.resolver.generateHash((InputStream)is);
        Assert.assertEquals((Object)"abcdef", (Object)generateHash.getHash());
        Assert.assertEquals((Object)"html", (Object)generateHash.getStoreName());
        this.m.assertIsSatisfied();
    }

    @Test
    public void partition() throws Exception {
        String hash = "1234567890abcdef1234567890abcdef";
        String expected = FilenameUtils.separatorsToSystem((String)"12/34/56/78/90/abcdef1234567890abcdef.data");
        Assert.assertEquals((Object)expected, (Object)FileSystemBackedHashResolver.partition((String)hash));
    }

    @Test(expected=IllegalArgumentException.class)
    public void resolveFilenameMissingDotDataExtension() {
        String filePath = FilenameUtils.separatorsToSystem((String)"ab/cd/ef/_-/12/345__6--7890__abcdef1234567890__abcdef1234567890");
        File file = new File(root, filePath);
        this.resolver.resolve(file, "test");
    }
}

