/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash;

import org.junit.Assert;
import org.junit.Test;
import uk.ac.warwick.util.files.hash.HashString;

public class HashStringTest {
    @Test
    public void unqualified() {
        HashString hash = new HashString("3782139f8038493280438a8a0");
        Assert.assertEquals((Object)"3782139f8038493280438a8a0", (Object)hash.getHash());
        Assert.assertEquals(null, (Object)hash.getStoreName());
        Assert.assertTrue((boolean)hash.isDefaultStore());
    }

    @Test
    public void qualified() {
        HashString hash = new HashString("html/3782139f8038493280438a8a0");
        Assert.assertEquals((Object)"3782139f8038493280438a8a0", (Object)hash.getHash());
        Assert.assertEquals((Object)"html", (Object)hash.getStoreName());
        Assert.assertFalse((boolean)hash.isDefaultStore());
    }

    @Test
    public void defaultStore() {
        HashString hash = new HashString("default/12345678");
        Assert.assertEquals((Object)"12345678", (Object)hash.getHash());
        Assert.assertEquals((Object)"12345678", (Object)hash.toString());
        Assert.assertTrue((boolean)hash.isDefaultStore());
    }

    @Test
    public void defaultStoreConstructor() {
        HashString hash = new HashString("default", "12345678");
        Assert.assertEquals((Object)"12345678", (Object)hash.getHash());
        Assert.assertEquals((Object)"12345678", (Object)hash.toString());
        Assert.assertTrue((boolean)hash.isDefaultStore());
    }

    @Test(expected=IllegalArgumentException.class)
    public void emptyHash() throws Exception {
        new HashString("html/");
    }

    @Test
    public void nullInput() throws Exception {
        HashString hash = new HashString(null);
        Assert.assertTrue((boolean)hash.isEmpty());
    }
}

