/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Instant;
import org.apache.commons.io.FilenameUtils;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.core.spring.FileUtils;
import uk.ac.warwick.util.files.FileData;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.LocalFileStore;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.AbstractFileBackedFileData;
import uk.ac.warwick.util.files.impl.AbstractFileReference;

public final class FileBackedLocalFileReference
extends AbstractFileReference
implements LocalFileReference {
    private final File file;
    private final Data data;
    private final String path;
    private final LocalFileStore fileStore;
    private final Storeable.StorageStrategy storageStrategy;

    public FileBackedLocalFileReference(LocalFileStore store, File f, String thepath, Storeable.StorageStrategy theStorageStrategy) {
        this.fileStore = store;
        this.file = f;
        this.path = FilenameUtils.separatorsToUnix((String)thepath);
        this.data = new Data();
        this.storageStrategy = theStorageStrategy;
    }

    @Override
    public FileData<FileReference> getData() {
        return this.data;
    }

    @Override
    public String getFileName() {
        return FileUtils.getFileName((String)this.path);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HashString getHash() {
        return null;
    }

    @Override
    public LocalFileReference copyTo(FileReference target) throws IOException {
        return this.copyTo(target.toLocalReference().getPath());
    }

    @Override
    public LocalFileReference copyTo(String target) throws IOException {
        return this.copyTo(new FileStoreable(this.storageStrategy, target));
    }

    private LocalFileReference copyTo(Storeable target) throws IOException {
        return this.fileStore.copy(this, target);
    }

    @Override
    public LocalFileReference renameTo(FileReference target) throws IOException {
        return this.renameTo(target.toLocalReference().getPath());
    }

    @Override
    public LocalFileReference renameTo(String target) throws IOException {
        return this.renameTo(new FileStoreable(this.storageStrategy, target));
    }

    private LocalFileReference renameTo(Storeable target) throws IOException {
        return this.fileStore.rename(this, target);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public Instant getLastModified() {
        return this.data.getLastModified();
    }

    @Override
    public Storeable.StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.getPath() + " (" + this.data.toString() + ")";
    }

    @Override
    public void unlink() {
        this.getData().delete();
    }

    private static class FileStoreable
    implements Storeable {
        private final String path;
        private final Storeable.StorageStrategy strategy;

        FileStoreable(Storeable.StorageStrategy theStrategy, String thePath) {
            this.strategy = theStrategy;
            this.path = thePath;
        }

        @Override
        public Storeable.StorageStrategy getStrategy() {
            return this.strategy;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public HashString getHash() {
            return null;
        }
    }

    class Data
    extends AbstractFileBackedFileData {
        private Data() {
            super(FileBackedLocalFileReference.this.fileStore);
        }

        Instant getLastModified() {
            return Instant.ofEpochMilli(this.getFile().lastModified());
        }

        @Override
        public File getFile() {
            return FileBackedLocalFileReference.this.file;
        }

        public LocalFileReference overwrite(ByteSource in) throws IOException {
            FileBackedLocalFileReference thisReference = FileBackedLocalFileReference.this;
            FileCopyUtils.copy((InputStream)in.openBufferedStream(), (OutputStream)new FileOutputStream(FileBackedLocalFileReference.this.file));
            return thisReference;
        }
    }
}

