/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import java.io.File;
import java.util.Collections;
import java.util.Properties;
import org.jclouds.ContextBuilder;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.filesystem.FilesystemApiMetadata;
import org.jclouds.logging.slf4j.config.SLF4JLoggingModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.files.impl.AzureClientFactory;
import uk.ac.warwick.util.files.impl.ContainerRenamingBlobStore;
import uk.ac.warwick.util.files.impl.DelegatingBlobStoreContext;
import uk.ac.warwick.util.files.impl.RenameMode;
import uk.ac.warwick.util.files.impl.WriteToAzureBlobStoreContext;

public class BlobStoreContextFactoryBean
extends AbstractFactoryBean<BlobStoreContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlobStoreContextFactoryBean.class);
    @Value(value="${objectstore.provider:swift}")
    private String providerType;
    @Value(value="${objectstore.swift.endpoint:}")
    private String swiftEndpoint;
    @Value(value="${objectstore.swift.username:}")
    private String swiftUsername;
    @Value(value="${objectstore.swift.password:}")
    private String swiftPassword;
    @Value(value="${objectstore.azure.endpoint:}")
    private String azureEndpoint;
    @Value(value="${objectstore.azure.username:}")
    private String azureUsername;
    @Value(value="${objectstore.azure.password:}")
    private String azurePassword;
    @Value(value="${objectstore.fileSystem.root:}")
    private String fileSystemRoot;
    private Properties overrides = new Properties();

    public Class<BlobStoreContext> getObjectType() {
        return BlobStoreContext.class;
    }

    protected BlobStoreContext createInstance() throws Exception {
        switch (this.providerType) {
            case "inMemory": {
                return (BlobStoreContext)ContextBuilder.newBuilder((ApiMetadata)new TransientApiMetadata()).modules(Collections.singleton(new SLF4JLoggingModule())).buildView(BlobStoreContext.class);
            }
            case "fileSystem": {
                return this.getFileSystemContext();
            }
            case "azure": {
                return this.getAzureContext();
            }
            case "swift": {
                return this.getSwiftContext();
            }
            case "swift+azure": {
                return this.getSwiftPlusAzureContext();
            }
        }
        LOGGER.warn("Unknown objectstore.provider '" + this.providerType + "'; defaulting to swift");
        return this.getSwiftContext();
    }

    private BlobStoreContext getAzureContext() {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.azureUsername), (String)"The property objectstore.azure.username must be non-empty");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.azurePassword), (String)"The property objectstore.azure.password must be non-empty");
        String endpoint = this.getAzureEndpoint();
        if (!ClassUtils.isPresent((String)"org.jclouds.azureblob.AzureBlobApiMetadata", null)) {
            LOGGER.warn("AzureBlobApiMetadata not found - if you see an error after this, you probably need to add the jclouds azureblob provider to your classpath.");
        }
        final BlobStoreContext realContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"azureblob").endpoint(endpoint).credentials(this.azureUsername, this.azurePassword).modules(Collections.singleton(new SLF4JLoggingModule())).overrides(this.overrides).buildView(BlobStoreContext.class);
        return new DelegatingBlobStoreContext(realContext){

            @Override
            public BlobStore getBlobStore() {
                return new ContainerRenamingBlobStore(this, realContext.getBlobStore(), RenameMode.NO_DOTS);
            }
        };
    }

    private String getAzureEndpoint() {
        return StringUtils.hasText((String)this.azureEndpoint) ? this.azureEndpoint : String.format("https://%s.blob.core.windows.net/", this.azureUsername);
    }

    private BlobStoreContext getSwiftContext() {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.swiftEndpoint), (String)"The property objectstore.swift.endpoint must be non-empty");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.swiftUsername), (String)"The property objectstore.swift.username must be non-empty");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.swiftPassword), (String)"The property objectstore.swift.password must be non-empty");
        return (BlobStoreContext)ContextBuilder.newBuilder((String)"openstack-swift").endpoint(this.swiftEndpoint).credentials(String.format("LDAP_%s:%s", this.swiftUsername, this.swiftUsername), this.swiftPassword).modules(Collections.singleton(new SLF4JLoggingModule())).buildView(BlobStoreContext.class);
    }

    private BlobStoreContext getSwiftPlusAzureContext() {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.azureUsername), (String)"The property objectstore.azure.username must be non-empty");
        Assert.isTrue((boolean)StringUtils.hasText((String)this.azurePassword), (String)"The property objectstore.azure.password must be non-empty");
        if (!ClassUtils.isPresent((String)"com.azure.storage.blob.BlobServiceClient", null)) {
            throw new IllegalStateException("Swift+Azure requires com.azure:azure-storage-blob to be on the classpath");
        }
        return new WriteToAzureBlobStoreContext(this.getSwiftContext(), AzureClientFactory.getAzureClient(this.azureUsername, this.azurePassword, this.getAzureEndpoint()));
    }

    private BlobStoreContext getFileSystemContext() {
        Assert.isTrue((boolean)StringUtils.hasText((String)this.fileSystemRoot), (String)"The property objectstore.fileSystem.root must be non-empty");
        final File root = new File(this.fileSystemRoot);
        Assert.isTrue(((root.exists() || root.mkdirs()) && root.isDirectory() ? 1 : 0) != 0, (String)("The root directory " + root + " must exist and be a directory"));
        return (BlobStoreContext)ContextBuilder.newBuilder((ApiMetadata)new FilesystemApiMetadata()).overrides(new Properties(){
            {
                this.setProperty("jclouds.filesystem.basedir", root.getAbsolutePath());
            }
        }).modules(Collections.singleton(new SLF4JLoggingModule())).buildView(BlobStoreContext.class);
    }

    public void setOverrides(Properties overrides) {
        this.overrides = overrides;
    }

    protected void destroyInstance(BlobStoreContext context) throws Exception {
        if (context != null) {
            context.close();
        }
    }
}

