/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.FileStoreStatistics;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.LocalFileReference;
import uk.ac.warwick.util.files.LocalFileStore;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.EmptyHashBackedFileReference;

public abstract class AbstractFileStore
implements LocalFileStore,
HashFileStore,
InitializingBean {
    private final Map<String, FileHashResolver> hashResolvers;
    private final FileReferenceCreationStrategy storageStrategy;
    protected FileStoreStatistics statistics = new DefaultFileStoreStatistics(this);

    public AbstractFileStore(Map<String, FileHashResolver> resolvers, FileReferenceCreationStrategy strategy) {
        this.hashResolvers = resolvers;
        this.storageStrategy = strategy;
    }

    private FileHashResolver getHashResolver(String hashStoreName) {
        String key = hashStoreName;
        if (key == null) {
            key = "default";
        }
        return this.hashResolvers.get(key);
    }

    private FileHashResolver getHashResolver(HashString hashString) {
        if (hashString.isDefaultStore()) {
            return this.getHashResolver("default");
        }
        return this.getHashResolver(hashString.getStoreName());
    }

    @Override
    public FileReference store(Storeable storeable, String requestedStoreName, ByteSource in) throws IOException {
        FileReferenceCreationStrategy.Target target = this.storageStrategy.select(in);
        switch (target) {
            case local: {
                return this.storeLocalReference(storeable, in);
            }
            case hash: {
                return this.storeHashReference(in, requestedStoreName);
            }
        }
        throw new IllegalStateException("Unhandled strategy; " + (Object)((Object)target));
    }

    @Override
    public HashFileReference createHashReference(ByteSource in, String requestedStoreName) throws IOException {
        return this.storeHashReference(in, requestedStoreName);
    }

    @Override
    public HashFileReference storeHashReference(ByteSource in, String requestedHashStore) throws IOException {
        HashString hash;
        FileHashResolver hashResolver = this.getHashResolver(requestedHashStore);
        try (InputStream is = in.openBufferedStream();){
            hash = hashResolver.generateHash(is);
        }
        HashFileReference existing = hashResolver.lookupByHash(this, hash, true);
        if (existing.isExists()) {
            return existing;
        }
        return this.doStore(in, hash, existing);
    }

    abstract HashFileReference doStore(ByteSource var1, HashString var2, HashFileReference var3) throws IOException;

    private HashFileReference getByFileHash(HashString fileHash) {
        return this.getHashResolver(fileHash).lookupByHash(this, fileHash, false);
    }

    @Override
    public FileReference get(Storeable storeable) throws FileNotFoundException {
        FileReference ref;
        if (storeable.getHash() != null && !storeable.getHash().isEmpty()) {
            return this.getByFileHash(storeable.getHash());
        }
        LocalFileReference localRef = null;
        if (storeable.getStrategy().isSupportsLocalReferences() || storeable.getStrategy().getMissingContentStrategy() == Storeable.StorageStrategy.MissingContentStrategy.Local) {
            localRef = this.getForPath(storeable.getStrategy(), storeable.getPath());
        }
        if (localRef != null && localRef.isExists()) {
            ref = localRef;
        } else {
            switch (storeable.getStrategy().getMissingContentStrategy()) {
                case Local: {
                    ref = localRef;
                    break;
                }
                case Hash: {
                    ref = new EmptyHashBackedFileReference(this, storeable.getStrategy().getDefaultHashStore());
                    break;
                }
                case Exception: {
                    throw new FileNotFoundException("Couldn't find a file reference for " + storeable);
                }
                default: {
                    throw new IllegalArgumentException("Unsupported missing content strategy: " + (Object)((Object)storeable.getStrategy().getMissingContentStrategy()));
                }
            }
        }
        return ref;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.hashResolvers.containsKey("default")) {
            throw new IllegalArgumentException("No default hash resolver provided");
        }
    }

    @Override
    public FileStoreStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(FileStoreStatistics statistics) {
        this.statistics = statistics;
    }
}

