/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.FileStoreStatistics;

public class DefaultFileStoreStatistics
implements FileStoreStatistics {
    private final FileStore fileStore;
    private volatile boolean statisticsEnabled = false;
    private long startTime;
    private AtomicLong referenceOpenedCount = new AtomicLong();
    private AtomicLong referenceOpenedTime = new AtomicLong();
    private AtomicLong referenceReadCount = new AtomicLong();
    private AtomicLong referenceReadTime = new AtomicLong();
    private AtomicLong referenceWrittenCount = new AtomicLong();
    private AtomicLong referenceWrittenTime = new AtomicLong();
    private AtomicLong referenceDeletedCount = new AtomicLong();
    private AtomicLong referenceDeletedTime = new AtomicLong();
    private AtomicLong traversedCount = new AtomicLong();
    private AtomicLong traversedTime = new AtomicLong();

    public DefaultFileStoreStatistics(FileStore fileStore) {
        this.clear();
        this.fileStore = fileStore;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public void clear() {
        this.referenceOpenedCount.set(0L);
        this.referenceOpenedTime.set(0L);
        this.referenceReadCount.set(0L);
        this.referenceReadTime.set(0L);
        this.referenceWrittenCount.set(0L);
        this.referenceWrittenTime.set(0L);
        this.referenceDeletedCount.set(0L);
        this.referenceDeletedTime.set(0L);
        this.traversedCount.set(0L);
        this.traversedTime.set(0L);
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void referenceOpened(long timeTakenMs) {
        this.referenceOpenedCount.getAndIncrement();
        this.referenceOpenedTime.getAndAdd(timeTakenMs);
    }

    @Override
    public void referenceRead(long timeTakenMs) {
        this.referenceReadCount.getAndIncrement();
        this.referenceReadTime.getAndAdd(timeTakenMs);
    }

    @Override
    public void referenceWritten(long timeTakenMs) {
        this.referenceWrittenCount.getAndIncrement();
        this.referenceWrittenTime.getAndAdd(timeTakenMs);
    }

    @Override
    public void referenceDeleted(long timeTakenMs) {
        this.referenceDeletedCount.getAndIncrement();
        this.referenceDeletedTime.getAndAdd(timeTakenMs);
    }

    @Override
    public void traversed(long timeTakenMs) {
        this.traversedCount.getAndIncrement();
        this.traversedTime.getAndAdd(timeTakenMs);
    }

    public long getReferenceOpenedCount() {
        return this.referenceOpenedCount.get();
    }

    public long getReferenceOpenedTime() {
        return this.referenceOpenedTime.get();
    }

    public long getReferenceReadCount() {
        return this.referenceReadCount.get();
    }

    public long getReferenceReadTime() {
        return this.referenceReadTime.get();
    }

    public long getReferenceWrittenCount() {
        return this.referenceWrittenCount.get();
    }

    public long getReferenceWrittenTime() {
        return this.referenceWrittenTime.get();
    }

    public long getReferenceDeletedCount() {
        return this.referenceDeletedCount.get();
    }

    public long getReferenceDeletedTime() {
        return this.referenceDeletedTime.get();
    }

    public long getTraversedCount() {
        return this.traversedCount.get();
    }

    public long getTraversedTime() {
        return this.traversedTime.get();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("startTime", this.startTime).append("referenceOpenedCount", (Object)this.referenceOpenedCount).append("referenceOpenedTime", (Object)this.referenceOpenedTime).append("referenceReadCount", (Object)this.referenceReadCount).append("referenceReadTime", (Object)this.referenceReadTime).append("referenceWrittenCount", (Object)this.referenceWrittenCount).append("referenceWrittenTime", (Object)this.referenceWrittenTime).append("referenceDeletedCount", (Object)this.referenceDeletedCount).append("referenceDeletedTime", (Object)this.referenceDeletedTime).append("traversedCount", (Object)this.traversedCount).append("traversedTime", (Object)this.traversedTime).toString();
    }
}

