/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import uk.ac.warwick.util.files.impl.ContainerRenamingBlobStore;
import uk.ac.warwick.util.files.impl.RenameMode;

public class ContainerRenamingBlobStoreTest {
    private JUnit4Mockery m = new JUnit4Mockery();

    @Test
    public void translation() {
        final BlobStore delegate = (BlobStore)this.m.mock(BlobStore.class);
        ContainerRenamingBlobStore store = new ContainerRenamingBlobStore((BlobStoreContext)this.m.mock(BlobStoreContext.class), delegate, RenameMode.NO_DOTS);
        final Blob blob = (Blob)this.m.mock(Blob.class);
        final BlobMetadata metadata = (BlobMetadata)this.m.mock(BlobMetadata.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((BlobStore)this.exactly(1).of((Object)delegate)).getBlob("uk-ac-warwick-sbr-html", "xyz");
                ((BlobStore)this.exactly(1).of((Object)delegate)).putBlob("uk-ac-warwick-sbr-html", blob);
                ((BlobStore)this.exactly(1).of((Object)delegate)).initiateMultipartUpload("uk-ac-warwick-sbr-html", metadata, null);
            }
        });
        store.getBlob("uk.ac.warwick.sbr.html", "xyz");
        store.putBlob("uk.ac.warwick.sbr.html", blob);
        store.initiateMultipartUpload("uk.ac.warwick.sbr.html", metadata, null);
    }
}

