/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.google.common.io.ByteSource;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.stream.Collectors;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.FileReferenceCreationStrategy;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.impl.BlobStoreBackedHashResolver;
import uk.ac.warwick.util.files.hash.impl.SHAFileHasher;
import uk.ac.warwick.util.files.impl.BlobStoreFileStore;

public class BlobStoreFileStoreTest {
    private static final String CONTAINER_PREFIX = "uk.ac.warwick.sbr.";
    private static final byte[] DATA = "Hello".getBytes();
    private final Mockery m = new JUnit4Mockery();
    private final MaintenanceModeFlags flags = () -> false;
    private final HashInfoDAO sbd = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
    private final BlobStoreContext blobStoreContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"transient").buildView(BlobStoreContext.class);
    private final BlobStoreBackedHashResolver resolver = new BlobStoreBackedHashResolver(this.blobStoreContext, "uk.ac.warwick.sbr.", "html", (FileHasher)new SHAFileHasher(), this.sbd, this.flags);
    private final FileReferenceCreationStrategy strategy = (FileReferenceCreationStrategy)this.m.mock(FileReferenceCreationStrategy.class);
    private final BlobStoreFileStore fileStore = new BlobStoreFileStore(Collections.singletonMap("html", this.resolver), this.strategy, this.blobStoreContext, "uk.ac.warwick.sbr.");

    @Before
    public void setUpHere() throws Exception {
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                this.ignoring(BlobStoreFileStoreTest.this.sbd);
            }
        });
        this.resolver.afterPropertiesSet();
    }

    @After
    public void tearDownHere() throws Exception {
        this.blobStoreContext.close();
    }

    @Test
    public void storeHashHtmlFile() throws Exception {
        final Storeable s = (Storeable)this.m.mock(Storeable.class);
        final Storeable.StorageStrategy ss = (Storeable.StorageStrategy)this.m.mock(Storeable.StorageStrategy.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileReferenceCreationStrategy)this.oneOf(BlobStoreFileStoreTest.this.strategy)).select((ByteSource)this.with(2.any(ByteSource.class)));
                this.will(2.returnValue((Object)FileReferenceCreationStrategy.Target.hash));
                ((Storeable)this.allowing(s)).getPath();
                this.will(2.returnValue((Object)"/file.htm"));
                ((Storeable)this.allowing(s)).getStrategy();
                this.will(2.returnValue((Object)ss));
                ((Storeable.StorageStrategy)this.allowing(ss)).getRootPath();
                this.will(2.returnValue((Object)"html"));
            }
        });
        FileReference ref = this.fileStore.store(s, "html", ByteSource.wrap((byte[])DATA));
        Blob blob = this.blobStoreContext.getBlobStore().getBlob("uk.ac.warwick.sbr.html", "f7ff9e8b7bb2e09b70935a5d785e0cc5d9d0abf0");
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"Hello", (Object)FileCopyUtils.copyToString((Reader)new InputStreamReader(blob.getPayload().openStream())));
        Assert.assertEquals((Object)"Hello", (Object)ref.asByteSource().asCharSource(StandardCharsets.UTF_8).read());
        Assert.assertEquals((Object)"el", (Object)ref.asByteSource().slice(1L, 2L).asCharSource(StandardCharsets.UTF_8).read());
        this.m.assertIsSatisfied();
    }

    @Test
    public void storeLocalFile() throws Exception {
        final Storeable s = (Storeable)this.m.mock(Storeable.class);
        final Storeable.StorageStrategy ss = (Storeable.StorageStrategy)this.m.mock(Storeable.StorageStrategy.class);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileReferenceCreationStrategy)this.oneOf(BlobStoreFileStoreTest.this.strategy)).select((ByteSource)this.with(3.any(ByteSource.class)));
                this.will(3.returnValue((Object)FileReferenceCreationStrategy.Target.local));
                ((Storeable)this.allowing(s)).getPath();
                this.will(3.returnValue((Object)"/file.htm"));
                ((Storeable)this.allowing(s)).getStrategy();
                this.will(3.returnValue((Object)ss));
                ((Storeable.StorageStrategy)this.allowing(ss)).getRootPath();
                this.will(3.returnValue((Object)"html"));
            }
        });
        FileReference ref = this.fileStore.store(s, "html", ByteSource.wrap((byte[])DATA));
        Blob blob = this.blobStoreContext.getBlobStore().getBlob("uk.ac.warwick.sbr.html", "/file.htm");
        Assert.assertNotNull((Object)blob);
        Assert.assertEquals((Object)"Hello", (Object)FileCopyUtils.copyToString((Reader)new InputStreamReader(blob.getPayload().openStream())));
        Assert.assertEquals((Object)"Hello", (Object)ref.asByteSource().asCharSource(StandardCharsets.UTF_8).read());
        Assert.assertEquals((Object)"el", (Object)ref.asByteSource().slice(1L, 2L).asCharSource(StandardCharsets.UTF_8).read());
        Assert.assertEquals(Collections.singletonList("/file.htm"), this.fileStore.list(ss, "").collect(Collectors.toList()));
        Assert.assertEquals(Collections.emptyList(), this.fileStore.list(ss, "dir").collect(Collectors.toList()));
        this.m.assertIsSatisfied();
    }
}

