/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStoreContext;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.core.MaintenanceModeFlags;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.dao.HashInfoDAO;
import uk.ac.warwick.util.files.hash.FileHasher;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.hash.impl.BlobStoreBackedHashResolver;
import uk.ac.warwick.util.files.impl.BlobBackedHashFileReference;

public final class BlobStoreBackedHashResolverTest {
    private static final String CONTAINER_PREFIX = "uk.ac.warwick.sbr.";
    private final Mockery m = new JUnit4Mockery();
    private final FileHasher hasher = (FileHasher)this.m.mock(FileHasher.class);
    private final HashFileStore store = (HashFileStore)this.m.mock(HashFileStore.class);
    private final HashInfoDAO dao = (HashInfoDAO)this.m.mock(HashInfoDAO.class);
    private final MaintenanceModeFlags flags = () -> false;
    private final BlobStoreContext blobStoreContext = (BlobStoreContext)ContextBuilder.newBuilder((String)"transient").buildView(BlobStoreContext.class);
    private final BlobStoreBackedHashResolver htmlResolver = new BlobStoreBackedHashResolver(this.blobStoreContext, "uk.ac.warwick.sbr.", "html", this.hasher, this.dao, this.flags);
    private final BlobStoreBackedHashResolver defaultResolver = new BlobStoreBackedHashResolver(this.blobStoreContext, "uk.ac.warwick.sbr.", "default", this.hasher, this.dao, this.flags);

    @Before
    public void setup() throws Exception {
        this.htmlResolver.afterPropertiesSet();
        this.defaultResolver.afterPropertiesSet();
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashFileStore)this.allowing(BlobStoreBackedHashResolverTest.this.store)).getStatistics();
                this.will(1.returnValue((Object)new DefaultFileStoreStatistics((FileStore)BlobStoreBackedHashResolverTest.this.store)));
            }
        });
    }

    @After
    public void shutdown() {
        this.blobStoreContext.close();
    }

    @Test(expected=IllegalArgumentException.class)
    public void hashNotBelongingToMe() {
        HashString hash = new HashString("tiftof");
        this.htmlResolver.lookupByHash(this.store, hash, true);
    }

    @Test
    public void lookupByHashDefault() throws Exception {
        String hash = "abcdefghijklmn";
        final HashString hashString = new HashString("abcdefghijklmn");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashInfoDAO)this.oneOf(BlobStoreBackedHashResolverTest.this.dao)).getHashByIdWithoutFlush(hashString.toString());
                this.will(2.returnValue(null));
                ((HashInfoDAO)this.oneOf(BlobStoreBackedHashResolverTest.this.dao)).hashCreated(hashString, 0L);
            }
        });
        BlobBackedHashFileReference reference = this.defaultResolver.lookupByHash(this.store, hashString, true);
        Assert.assertEquals((Object)"abcdefghijklmn", (Object)reference.getHash().toString());
    }

    @Test
    public void lookupByHash() throws Exception {
        HashString hash = new HashString("html", "abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890");
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashInfoDAO)this.oneOf(BlobStoreBackedHashResolverTest.this.dao)).getHashByIdWithoutFlush("html/abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890");
                this.will(3.returnValue(null));
                ((HashInfoDAO)this.oneOf(BlobStoreBackedHashResolverTest.this.dao)).hashCreated(new HashString("html/abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890"), 0L);
            }
        });
        BlobBackedHashFileReference reference = this.htmlResolver.lookupByHash(this.store, hash, true);
        Assert.assertNotNull((Object)reference);
        Assert.assertEquals((Object)hash, (Object)reference.getHash());
        Assert.assertFalse((boolean)reference.isExists());
        Assert.assertFalse((boolean)reference.isFileBacked());
        this.blobStoreContext.getBlobStore().putBlob("uk.ac.warwick.sbr.html", this.blobStoreContext.getBlobStore().blobBuilder("abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890").payload("File contents").contentDisposition("abcdef_-12345__6--7890__abcdef1234567890__abcdef1234567890").contentLength(13L).build());
        Assert.assertEquals((Object)hash, (Object)reference.getHash());
        Assert.assertTrue((boolean)reference.isExists());
        Assert.assertFalse((boolean)reference.isFileBacked());
    }

    @Test
    public void generateHash() throws Exception {
        String hash = "abcdef";
        final ByteArrayInputStream is = new ByteArrayInputStream(new byte[0]);
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileHasher)this.oneOf(BlobStoreBackedHashResolverTest.this.hasher)).hash(is);
                this.will(4.returnValue((Object)"abcdef"));
            }
        });
        HashString generateHash = this.htmlResolver.generateHash((InputStream)is);
        Assert.assertEquals((Object)"abcdef", (Object)generateHash.getHash());
        Assert.assertEquals((Object)"html", (Object)generateHash.getStoreName());
        this.m.assertIsSatisfied();
    }
}

