/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files;

import com.google.common.io.ByteSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileReference;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.FileStoreStatistics;
import uk.ac.warwick.util.files.HashFileReference;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.Storeable;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.impl.FileBackedHashFileReference;
import uk.ac.warwick.util.files.impl.FileBackedLocalFileReference;

class CheckingFileStore
implements HashFileStore {
    private final File file;
    boolean created;

    public CheckingFileStore(File theFile) {
        this.file = theFile;
    }

    public HashFileReference createHashReference(ByteSource in, String storeName) throws IOException {
        this.created = true;
        return new FileBackedHashFileReference(null, this.file, new HashString(storeName, "abcdef"));
    }

    public HashFileReference storeHashReference(ByteSource in, String storeName) throws IOException {
        this.created = true;
        return new FileBackedHashFileReference(null, this.file, new HashString(storeName, "abcdef"));
    }

    public FileReference get(Storeable storeable) throws FileNotFoundException {
        return new FileBackedLocalFileReference(null, this.file, storeable.getPath(), storeable.getStrategy());
    }

    public FileReference store(Storeable storeable, String storeName, ByteSource in) throws IOException {
        return null;
    }

    public FileStoreStatistics getStatistics() {
        return new DefaultFileStoreStatistics((FileStore)this);
    }
}

