package uk.ac.warwick.util.files.impl;

import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.junit.Test;

public class ContainerRenamingBlobStoreTest {
  private JUnit4Mockery m = new JUnit4Mockery();
  
  @Test
  public void translation() {
    BlobStore delegate = m.mock(BlobStore.class);
    ContainerRenamingBlobStore store = new ContainerRenamingBlobStore(m.mock(BlobStoreContext.class), delegate, RenameMode.NO_DOTS);
    Blob blob = m.mock(Blob.class);
    BlobMetadata metadata = m.mock(BlobMetadata.class);
    
    m.checking(new Expectations() {{
      exactly(1).of(delegate).getBlob("uk-ac-warwick-sbr-html", "xyz");
      exactly(1).of(delegate).putBlob("uk-ac-warwick-sbr-html", blob);
      exactly(1).of(delegate).initiateMultipartUpload("uk-ac-warwick-sbr-html", metadata, null);
    }});
    
    store.getBlob("uk.ac.warwick.sbr.html", "xyz");
    store.putBlob("uk.ac.warwick.sbr.html", blob);
    store.initiateMultipartUpload("uk.ac.warwick.sbr.html", metadata, null);
  }

}