package uk.ac.warwick.util.files.impl;

import com.azure.storage.blob.models.BlobRange;
import org.junit.Test;

import java.util.List;

import static java.util.stream.Collectors.joining;
import static org.junit.Assert.*;

public class AzureReplicatorTest {
  AzureReplicator replicator = new AzureReplicator(null, null);
  
  String format(List<BlobRange> ranges) {
    return ranges.stream()
      .map(BlobRange::toString)
      .collect(joining(", "));
  }
  
  @Test
  public void sliceRanges() {
    assertEquals("bytes=0-1999, bytes=2000-3999, bytes=4000-4999", format(replicator.sliceRanges(5000, 2000)));
    assertEquals("bytes=0-4999", format(replicator.sliceRanges(5000, 6000)));
  }

}