package uk.ac.warwick.util.files.imageresize;

import javax.imageio.ImageIO;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

class ImageReadUtils {
    private ImageReadUtils(){}

    static BufferedImage read(ByteArrayOutputStream output) throws IOException {
        return read(new ByteArrayInputStream(output.toByteArray()));
    }

    static BufferedImage read(InputStream in) throws IOException {
        return ImageIO.read(in);
    }
}
