package uk.ac.warwick.util.files.hash;

import java.util.Map;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

import com.google.common.collect.Maps;


public final class CompositeFileHashResolverTest {
    @Rule
    public JUnitRuleMockery m = new JUnitRuleMockery();
    private CompositeFileHashResolver resolver;
    private FileHashResolver defaultResolver;
    private FileHashResolver htmlResolver;

    @Before public void setUp() {
        Map<String, FileHashResolver> resolvers = Maps.newHashMap();
        defaultResolver = m.mock(FileHashResolver.class, "defaultResolver");
        htmlResolver = m.mock(FileHashResolver.class, "htmlResolver");
        resolvers.put("default", defaultResolver);
        resolvers.put("html", htmlResolver);
        resolver = new CompositeFileHashResolver(resolvers);
    }

    @Test public void useDefault() {
        m.checking(new Expectations(){{
            oneOf(defaultResolver).lookupByHash(null, new HashString("abcdefghjijklmn"), true);
        }});
        resolver.lookupByHash(null, new HashString("abcdefghjijklmn"), true);
    }

    @Test public void useHtmlStore() {
        m.checking(new Expectations(){{
            oneOf(htmlResolver).lookupByHash(null, new HashString("html/abcdefghjijklmn"), true);
        }});
        resolver.lookupByHash(null, new HashString("html/abcdefghjijklmn"), true);
    }


    @Test(expected=IllegalArgumentException.class) public void missingStore() {
        resolver.lookupByHash(null, new HashString("unknownstore/abcdefghjijklmn"), true);
    }
}
