/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.impl;

import com.azure.storage.blob.BlobServiceClient;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobAccess;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.blobstore.domain.BlobMetadata;
import org.jclouds.blobstore.domain.ContainerAccess;
import org.jclouds.blobstore.domain.MultipartPart;
import org.jclouds.blobstore.domain.MultipartUpload;
import org.jclouds.blobstore.domain.PageSet;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.options.CopyOptions;
import org.jclouds.blobstore.options.CreateContainerOptions;
import org.jclouds.blobstore.options.GetOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.jclouds.blobstore.options.PutOptions;
import org.jclouds.domain.Location;
import org.jclouds.io.Payload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.files.impl.AzureReplicator;
import uk.ac.warwick.util.files.impl.DelegatingBlobStoreContext;

public class WriteToAzureBlobStoreContext
extends DelegatingBlobStoreContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(WriteToAzureBlobStoreContext.class);
    private final BlobStoreContext baseContext;
    private final AzureReplicator replicator;

    public WriteToAzureBlobStoreContext(BlobStoreContext baseContext, BlobServiceClient azureClient) {
        super(baseContext);
        this.baseContext = baseContext;
        this.replicator = new AzureReplicator(baseContext, azureClient);
    }

    @Override
    public BlobStore getBlobStore() {
        return new WriteTwiceBlobStore(this.baseContext.getBlobStore());
    }

    public static void catchingExceptions(String description, Callable<?> function) {
        try {
            function.call();
        }
        catch (Exception e) {
            LOGGER.error(String.format("Caught error in Azure operation - %s", description), (Throwable)e);
        }
    }

    public class WriteTwiceBlobStore
    implements BlobStore {
        private final BlobStore primary;

        public WriteTwiceBlobStore(BlobStore primary) {
            this.primary = primary;
        }

        public BlobStoreContext getContext() {
            return WriteToAzureBlobStoreContext.this;
        }

        public BlobBuilder blobBuilder(String name) {
            return this.primary.blobBuilder(name);
        }

        public Set<? extends Location> listAssignableLocations() {
            return this.primary.listAssignableLocations();
        }

        public PageSet<? extends StorageMetadata> list() {
            return this.primary.list();
        }

        public boolean containerExists(String container) {
            boolean exists = this.primary.containerExists(container);
            WriteToAzureBlobStoreContext.catchingExceptions("checking container " + container, () -> {
                WriteToAzureBlobStoreContext.this.replicator.ensureContainer(container);
                return null;
            });
            return exists;
        }

        public boolean createContainerInLocation(Location location, String container) {
            boolean created = this.primary.createContainerInLocation(location, container);
            if (created) {
                WriteToAzureBlobStoreContext.catchingExceptions("creating container " + container, () -> {
                    WriteToAzureBlobStoreContext.this.replicator.getAzureContainerClient(container).create();
                    return null;
                });
            }
            return created;
        }

        public boolean createContainerInLocation(Location location, String container, CreateContainerOptions options) {
            boolean created = this.primary.createContainerInLocation(location, container, options);
            if (created) {
                WriteToAzureBlobStoreContext.catchingExceptions("creating container " + container, () -> {
                    WriteToAzureBlobStoreContext.this.replicator.getAzureContainerClient(container).create();
                    return null;
                });
            }
            return created;
        }

        public ContainerAccess getContainerAccess(String container) {
            return this.primary.getContainerAccess(container);
        }

        public void setContainerAccess(String container, ContainerAccess access) {
            this.primary.setContainerAccess(container, access);
        }

        public PageSet<? extends StorageMetadata> list(String container) {
            return this.primary.list(container);
        }

        public PageSet<? extends StorageMetadata> list(String container, ListContainerOptions options) {
            return this.primary.list(container, options);
        }

        public void clearContainer(String container) {
            this.primary.clearContainer(container);
        }

        public void clearContainer(String container, ListContainerOptions options) {
            this.primary.clearContainer(container, options);
        }

        public void deleteContainer(String container) {
            this.primary.deleteContainer(container);
        }

        public boolean deleteContainerIfEmpty(String container) {
            return this.primary.deleteContainerIfEmpty(container);
        }

        public boolean directoryExists(String container, String directory) {
            return this.primary.directoryExists(container, directory);
        }

        public void createDirectory(String container, String directory) {
            this.primary.createDirectory(container, directory);
        }

        public void deleteDirectory(String containerName, String name) {
            this.primary.deleteDirectory(containerName, name);
        }

        public boolean blobExists(String container, String name) {
            return this.primary.blobExists(container, name);
        }

        public String putBlob(String container, Blob blob) {
            String result = this.primary.putBlob(container, blob);
            WriteToAzureBlobStoreContext.this.replicator.copyBlobToAzure(container, blob);
            return result;
        }

        public String putBlob(String container, Blob blob, PutOptions options) {
            String result = this.primary.putBlob(container, blob, options);
            WriteToAzureBlobStoreContext.this.replicator.copyBlobToAzure(container, blob);
            return result;
        }

        public String copyBlob(String fromContainer, String fromName, String toContainer, String toName, CopyOptions options) {
            String result = this.primary.copyBlob(fromContainer, fromName, toContainer, toName, options);
            WriteToAzureBlobStoreContext.this.replicator.copyBlobToAzure(toContainer, toName, null);
            return result;
        }

        public BlobMetadata blobMetadata(String container, String name) {
            return this.primary.blobMetadata(container, name);
        }

        public Blob getBlob(String container, String name) {
            return this.primary.getBlob(container, name);
        }

        public Blob getBlob(String container, String name, GetOptions options) {
            return this.primary.getBlob(container, name, options);
        }

        public void removeBlob(String container, String name) {
            this.primary.removeBlob(container, name);
        }

        public void removeBlobs(String container, Iterable<String> names) {
            this.primary.removeBlobs(container, names);
        }

        public BlobAccess getBlobAccess(String container, String name) {
            return this.primary.getBlobAccess(container, name);
        }

        public void setBlobAccess(String container, String name, BlobAccess access) {
            this.primary.setBlobAccess(container, name, access);
        }

        public long countBlobs(String container) {
            return this.primary.countBlobs(container);
        }

        public long countBlobs(String container, ListContainerOptions options) {
            return this.primary.countBlobs(container, options);
        }

        public MultipartUpload initiateMultipartUpload(String container, BlobMetadata blob, PutOptions options) {
            return this.primary.initiateMultipartUpload(container, blob, options);
        }

        public void abortMultipartUpload(MultipartUpload mpu) {
            this.primary.abortMultipartUpload(mpu);
        }

        public String completeMultipartUpload(MultipartUpload mpu, List<MultipartPart> parts) {
            Long size;
            String result = this.primary.completeMultipartUpload(mpu, parts);
            Long l = size = mpu.blobMetadata() == null ? null : mpu.blobMetadata().getSize();
            if (size == null) {
                BlobMetadata metadata = this.primary.blobMetadata(mpu.containerName(), mpu.blobName());
                size = metadata.getSize();
            }
            WriteToAzureBlobStoreContext.this.replicator.copyBlobToAzure(mpu.containerName(), mpu.blobName(), size);
            return result;
        }

        public MultipartPart uploadMultipartPart(MultipartUpload mpu, int partNumber, Payload payload) {
            return this.primary.uploadMultipartPart(mpu, partNumber, payload);
        }

        public List<MultipartPart> listMultipartUpload(MultipartUpload mpu) {
            return this.primary.listMultipartUpload(mpu);
        }

        public List<MultipartUpload> listMultipartUploads(String container) {
            return this.primary.listMultipartUploads(container);
        }

        public long getMinimumMultipartPartSize() {
            return this.primary.getMinimumMultipartPartSize();
        }

        public long getMaximumMultipartPartSize() {
            return this.primary.getMaximumMultipartPartSize();
        }

        public int getMaximumNumberOfParts() {
            return this.primary.getMaximumNumberOfParts();
        }

        public void downloadBlob(String container, String name, File destination) {
            this.primary.downloadBlob(container, name, destination);
        }

        public void downloadBlob(String container, String name, File destination, ExecutorService executor) {
            this.primary.downloadBlob(container, name, destination, executor);
        }

        public InputStream streamBlob(String container, String name) {
            return this.primary.streamBlob(container, name);
        }

        public InputStream streamBlob(String container, String name, ExecutorService executor) {
            return this.primary.streamBlob(container, name, executor);
        }
    }
}

