/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash;

import uk.ac.warwick.util.core.StringUtils;

public final class HashString {
    public static final char SEPARATOR_CHAR = '/';
    public static final String DEFAULT_STORE = "default";
    private String qualifiedHash;
    private String hash;
    private String store;

    public HashString(String qualifiedHashString) {
        this.parse(qualifiedHashString);
    }

    public HashString(String storeName, String hashed) {
        this.setData(storeName, hashed);
    }

    private void setData(String storeName, String hashed) {
        if (storeName == null || DEFAULT_STORE.equals(storeName)) {
            this.qualifiedHash = hashed;
            this.hash = hashed;
        } else {
            this.qualifiedHash = storeName + '/' + hashed;
            this.hash = hashed;
            this.store = storeName;
        }
    }

    public String getStoreName() {
        return this.store;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isEmpty() {
        return !StringUtils.hasLength((String)this.qualifiedHash);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HashString)) {
            return false;
        }
        return this.qualifiedHash.equals(((HashString)obj).qualifiedHash);
    }

    public int hashCode() {
        return this.qualifiedHash.hashCode();
    }

    public String toString() {
        return this.qualifiedHash;
    }

    public boolean isDefaultStore() {
        return this.store == null || DEFAULT_STORE.equals(this.store);
    }

    private void parse(String qualified) {
        this.qualifiedHash = qualified;
        if (this.isEmpty()) {
            return;
        }
        int index = qualified.indexOf(47);
        if (index < 0) {
            this.setData(null, qualified);
        } else {
            this.setData(qualified.substring(0, index), qualified.substring(index + 1));
        }
        if (this.hash.isEmpty()) {
            throw new IllegalArgumentException("Hash part must not be empty");
        }
    }
}

