/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.imageresize;

import com.google.common.io.ByteSource;
import com.google.common.io.Files;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.springframework.util.FileCopyUtils;
import uk.ac.warwick.util.collections.Pair;
import uk.ac.warwick.util.files.DefaultFileStoreStatistics;
import uk.ac.warwick.util.files.FileStore;
import uk.ac.warwick.util.files.HashFileStore;
import uk.ac.warwick.util.files.hash.HashString;
import uk.ac.warwick.util.files.imageresize.ImageIoResizer;
import uk.ac.warwick.util.files.imageresize.ImageReadUtils;
import uk.ac.warwick.util.files.imageresize.ImageResizer;
import uk.ac.warwick.util.files.imageresize.SingleThreadedImageResizer;
import uk.ac.warwick.util.files.impl.FileBackedHashFileReference;

@RunWith(value=Parameterized.class)
public class ImageIoResizerTest {
    ImageResizer resizer;
    ZonedDateTime lastModified = ZonedDateTime.now();
    private final Mockery m = new JUnit4Mockery();
    private final HashFileStore fileStore = (HashFileStore)this.m.mock(HashFileStore.class);
    final boolean outputToFiles = true;
    File temporaryDirectory;

    public ImageIoResizerTest(String name, ImageResizer imageResizer) {
        this.resizer = imageResizer;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> parameters() {
        return Arrays.asList({"ImageIoResizer", new ImageIoResizer()}, {"SingleThreadedImageResizer", new SingleThreadedImageResizer((ImageResizer)new ImageIoResizer())});
    }

    @Before
    public void setup() {
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((HashFileStore)this.allowing(ImageIoResizerTest.this.fileStore)).getStatistics();
                this.will(1.returnValue((Object)new DefaultFileStoreStatistics((FileStore)ImageIoResizerTest.this.fileStore)));
            }
        });
        String tmp = System.getProperty("java.io.tmpdir");
        this.temporaryDirectory = new File(tmp, "ImageIoResizerTest");
        this.temporaryDirectory.mkdirs();
    }

    public Output newOutput(String name) throws IOException {
        File file = new File(this.temporaryDirectory, name);
        return new FileOutput(file);
    }

    @Test(timeout=5000L)
    public void decodingZtxtChunks() throws Exception {
        ByteSource input = this.readResource("/bad-zTXt-chunk.png");
        Output output = this.newOutput("bad-zTXt-chunk.png");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 300, 300, ImageResizer.FileType.jpg);
    }

    @Test
    public void resizeTallThinImage() throws IOException {
        ByteSource input = this.readResource("/tallThinSample.jpg");
        Output output = this.newOutput("tallThinSample_fromBytes.jpg");
        int maxWidth = 50;
        int maxHeight = 165;
        this.resizer.renderResized(input, null, null, output.getOutputStream(), maxWidth, maxHeight, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)maxWidth, (long)result.getWidth());
        Assert.assertTrue((maxHeight > result.getHeight() ? 1 : 0) != 0);
    }

    @Test
    public void resizeAsFileNotByteArray() throws Exception {
        File input = new File(Objects.requireNonNull(this.getClass().getResource("/tallThinSample.jpg")).getFile());
        Output output = this.newOutput("tallThinSample_fromFile.jpg");
        int maxWidth = 50;
        int maxHeight = 165;
        this.resizer.renderResized(Files.asByteSource((File)input), null, null, output.getOutputStream(), maxWidth, maxHeight, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)maxWidth, (long)result.getWidth());
        Assert.assertTrue((maxHeight > result.getHeight() ? 1 : 0) != 0);
    }

    @Test
    public void resizeTallThinImageByHeight() throws IOException {
        ByteSource input = this.readResource("/tallThinSample.jpg");
        Output output = this.newOutput("tallThinSample_byHeight.jpg");
        int maxWidth = 100;
        int maxHeight = 155;
        this.resizer.renderResized(input, null, null, output.getOutputStream(), maxWidth, maxHeight, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)155L, (long)result.getHeight());
    }

    @Test
    public void resizeShortWideImage() throws IOException {
        ByteSource input = this.readResource("/shortWideSample.jpg");
        Output output = this.newOutput("shortWideSample.jpg");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 50, 165, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)50L, (long)result.getWidth());
    }

    @Test
    public void fileReferenceInput() throws Exception {
        File f = new File(Objects.requireNonNull(this.getClass().getResource("/tallThinSample.jpg")).getFile());
        FileBackedHashFileReference ref = new FileBackedHashFileReference(this.fileStore, f, new HashString("abcdef"));
        Output output = this.newOutput("tallThinSample_fileRef.jpg");
        this.resizer.renderResized(ref.asByteSource(), ref.getHash(), this.lastModified, output.getOutputStream(), 50, 165, ImageResizer.FileType.jpg);
        byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)output.read());
        Assert.assertEquals((long)bytes.length, (long)this.resizer.getResizedImageLength(ref.asByteSource(), ref.getHash(), this.lastModified, 50, 165, ImageResizer.FileType.jpg));
    }

    @Test
    public void dontResizeLargerThanOriginal() throws IOException {
        ByteSource input = this.readResource("/tallThinSample.jpg");
        Output output = this.newOutput("tallThinSample_noEnlarge.jpg");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 150, 200, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)100L, (long)result.getWidth());
        Assert.assertEquals((long)165L, (long)result.getHeight());
        Assert.assertEquals((String)"Output should be the same as input", (long)input.size(), (long)output.size());
    }

    @Test
    public void PNGResizing() throws IOException {
        ByteSource input = this.readResource("/award.png");
        Output output = this.newOutput("award.jpg");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 110, 116, ImageResizer.FileType.png);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)109L, (long)result.getWidth());
        Assert.assertEquals((long)116L, (long)result.getHeight());
    }

    @Test
    public void resizingWebPImageWillFunctionCorrectly() throws Exception {
        ByteSource input = this.readResource("/computer.webp");
        Output output = this.newOutput("computer.webp");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 1234, 0, ImageResizer.FileType.webp);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)1234L, (long)result.getWidth());
        Assert.assertEquals((long)822L, (long)result.getHeight());
    }

    @Test
    public void readWebpAsJpeg() throws Exception {
        ByteSource input = this.readResource("/computer.webp");
        Output output = this.newOutput("computer.jpg");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 300, 0, ImageResizer.FileType.jpg);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)5760L, (long)result.getWidth());
    }

    @Test
    public void GIFResizing() throws IOException {
        ByteSource input = this.readResource("/hugeimage.gif");
        Output output = this.newOutput("hugeimage.gif");
        this.resizer.renderResized(input, null, null, output.getOutputStream(), 110, 116, ImageResizer.FileType.gif);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((long)110L, (long)result.getWidth());
        Assert.assertEquals((long)44L, (long)result.getHeight());
    }

    @Test
    public void resizeTheWorld() throws Exception {
        File input = new File(Objects.requireNonNull(this.getClass().getResource("/pendulum_crop1.jpg")).getFile());
        Output output = this.newOutput("pendulum_crop1.jpg");
        int maxWidth = 350;
        int maxHeight = 149;
        this.resizer.renderResized(Files.asByteSource((File)input), null, null, output.getOutputStream(), maxWidth, maxHeight, ImageResizer.FileType.jpg);
        Pair dimensions = ImageIoResizer.getDimensions((InputStream)output.read());
        Assert.assertEquals((long)24803L, (long)((Integer)dimensions.getLeft()).intValue());
        Assert.assertEquals((long)10559L, (long)((Integer)dimensions.getRight()).intValue());
    }

    @Test
    public void badImage() throws Exception {
        File f = new File(Objects.requireNonNull(this.getClass().getResource("/October.jpg")).getFile());
        FileBackedHashFileReference ref = new FileBackedHashFileReference(this.fileStore, f, new HashString("abcdef"));
        Output output = this.newOutput("October.jpg");
        this.resizer.renderResized(ref.asByteSource(), ref.getHash(), this.lastModified, output.getOutputStream(), 50, 165, ImageResizer.FileType.jpg);
        Assert.assertEquals((long)output.size(), (long)this.resizer.getResizedImageLength(ref.asByteSource(), ref.getHash(), this.lastModified, 50, 165, ImageResizer.FileType.jpg));
        Pair dimensions = ImageIoResizer.getDimensions((InputStream)output.read());
        Assert.assertEquals((long)50L, (long)((Integer)dimensions.getLeft()).intValue());
        Assert.assertEquals((long)25L, (long)((Integer)dimensions.getRight()).intValue());
    }

    @Test
    public void orientation() throws Exception {
        Assert.assertEquals((Object)ImageResizer.Orientation.Normal, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_0.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.Normal, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_1.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.Mirrored, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_2.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate180, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_3.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredVertically, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_4.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredRotate270, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_5.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate90, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_6.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredRotate90, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_7.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate270, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_8.jpg"), (ImageResizer.FileType)ImageResizer.FileType.jpg));
        for (int i = 0; i <= 8; ++i) {
            ByteSource input = this.readResource("/orientation/Portrait_" + i + ".jpg");
            Output output = this.newOutput("Portrait_" + i + ".jpg");
            this.resizer.renderResized(input, null, null, output.getOutputStream(), 0, 0, ImageResizer.FileType.jpg);
            BufferedImage result = ImageReadUtils.read(output.read());
            Assert.assertEquals((String)("Portrait " + i + " width"), (long)1200L, (long)result.getWidth());
            Assert.assertEquals((String)("Portrait " + i + " height"), (long)1800L, (long)result.getHeight());
        }
    }

    @Test
    public void webpOrientation() throws Exception {
        Assert.assertEquals((Object)ImageResizer.Orientation.Normal, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_0.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.Normal, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_1.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.Mirrored, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_2.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate180, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_3.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredVertically, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_4.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredRotate270, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_5.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate90, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_6.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.MirroredRotate90, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_7.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        Assert.assertEquals((Object)ImageResizer.Orientation.Rotate270, (Object)ImageIoResizer.getOrientation((InputStream)this.getClass().getResourceAsStream("/orientation/Portrait_8.webp"), (ImageResizer.FileType)ImageResizer.FileType.webp));
        for (int i = 0; i <= 8; ++i) {
            ByteSource input = this.readResource("/orientation/Portrait_" + i + ".webp");
            Output output = this.newOutput("Portrait_" + i + ".webp");
            this.resizer.renderResized(input, null, null, output.getOutputStream(), 0, 0, ImageResizer.FileType.webp);
            BufferedImage result = ImageReadUtils.read(output.read());
            Assert.assertEquals((long)1200L, (long)result.getWidth());
            Assert.assertEquals((long)1800L, (long)result.getHeight());
        }
    }

    @Test
    public void maxWidthAndOrientation() throws Exception {
        ByteSource portrait_6_90deg = this.readResource("/orientation/Portrait_6.webp");
        Output output = this.newOutput("Portrait_6_maxWidth.webp");
        this.resizer.renderResized(portrait_6_90deg, null, null, output.getOutputStream(), 1100, 0, ImageResizer.FileType.webp);
        BufferedImage result = ImageReadUtils.read(output.read());
        Assert.assertEquals((String)"maxWidth should apply to post-rotation width", (long)1100L, (long)result.getWidth());
    }

    private ByteSource readResource(String path) {
        return Files.asByteSource((File)new File(this.getClass().getResource(path).getFile()));
    }

    class BytesOutput
    implements Output {
        private final ByteArrayOutputStream outputStream;

        public BytesOutput(ByteArrayOutputStream outputStream) {
            this.outputStream = outputStream;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public InputStream read() throws FileNotFoundException {
            return new ByteArrayInputStream(this.outputStream.toByteArray());
        }

        @Override
        public long size() {
            return this.outputStream.size();
        }
    }

    class FileOutput
    implements Output {
        private final FileOutputStream outputStream;
        private final File file;

        public FileOutput(File file) throws FileNotFoundException {
            this.outputStream = new FileOutputStream(file);
            this.file = file;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public InputStream read() throws FileNotFoundException {
            return new FileInputStream(this.file);
        }

        @Override
        public long size() {
            return this.file.length();
        }
    }

    static interface Output {
        public OutputStream getOutputStream() throws FileNotFoundException;

        public InputStream read() throws FileNotFoundException;

        public long size();
    }
}

