/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.files.hash;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JUnitRuleMockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import uk.ac.warwick.util.files.hash.CompositeFileHashResolver;
import uk.ac.warwick.util.files.hash.FileHashResolver;
import uk.ac.warwick.util.files.hash.HashString;

public final class CompositeFileHashResolverTest {
    @Rule
    public JUnitRuleMockery m = new JUnitRuleMockery();
    private CompositeFileHashResolver resolver;
    private FileHashResolver defaultResolver;
    private FileHashResolver htmlResolver;

    @Before
    public void setUp() {
        HashMap resolvers = Maps.newHashMap();
        this.defaultResolver = (FileHashResolver)this.m.mock(FileHashResolver.class, "defaultResolver");
        this.htmlResolver = (FileHashResolver)this.m.mock(FileHashResolver.class, "htmlResolver");
        resolvers.put("default", this.defaultResolver);
        resolvers.put("html", this.htmlResolver);
        this.resolver = new CompositeFileHashResolver((Map)resolvers);
    }

    @Test
    public void useDefault() {
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileHashResolver)this.oneOf(CompositeFileHashResolverTest.this.defaultResolver)).lookupByHash(null, new HashString("abcdefghjijklmn"), true);
            }
        });
        this.resolver.lookupByHash(null, new HashString("abcdefghjijklmn"), true);
    }

    @Test
    public void useHtmlStore() {
        this.m.checking((ExpectationBuilder)new Expectations(){
            {
                ((FileHashResolver)this.oneOf(CompositeFileHashResolverTest.this.htmlResolver)).lookupByHash(null, new HashString("html/abcdefghjijklmn"), true);
            }
        });
        this.resolver.lookupByHash(null, new HashString("html/abcdefghjijklmn"), true);
    }

    @Test(expected=IllegalArgumentException.class)
    public void missingStore() {
        this.resolver.lookupByHash(null, new HashString("unknownstore/abcdefghjijklmn"), true);
    }
}

