/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import com.csvreader.CsvReader;
import com.csvreader.CsvWriter;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.csv.AbstractCSVDocument;
import uk.ac.warwick.util.csv.CSVException;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.CSVLineWriter;

public final class GoodCsvDocument<T>
extends AbstractCSVDocument<T> {
    public GoodCsvDocument(CSVLineWriter<T> theWriter, CSVLineReader<T> theReader) {
        super(theWriter, theReader);
    }

    @Override
    public List<T> read(Reader source) throws IOException, CSVException {
        ArrayList readLines = Lists.newArrayList();
        CsvReader delegate = new CsvReader(source);
        while (delegate.readRecord()) {
            if (delegate.getColumnCount() == 0) continue;
            Object o = this.getReader().constructNewObject();
            String[] values = delegate.getValues();
            boolean allBlank = true;
            for (String value : values) {
                if (!StringUtils.hasText((String)value)) continue;
                allBlank = false;
            }
            if (allBlank) continue;
            for (int i = 0; i < values.length; ++i) {
                this.getReader().setColumn(o, i, values[i]);
            }
            this.getReader().end(o);
            readLines.add(o);
        }
        this.getReader().endData();
        if (this.isStoreLines()) {
            this.getLines().addAll(readLines);
        }
        return readLines;
    }

    @Override
    public int validate(Reader source) throws IOException, CSVException {
        boolean first = true;
        int columns = 0;
        int lineNumber = 0;
        CsvReader delegate = new CsvReader(source);
        while (delegate.readRecord()) {
            ++lineNumber;
            if (delegate.getColumnCount() == 0) continue;
            if (first) {
                columns = delegate.getColumnCount();
                first = false;
                continue;
            }
            if (delegate.getColumnCount() == columns) continue;
            throw new CSVException("Error on line " + lineNumber + " - found " + delegate.getColumnCount() + " fields but expected " + columns);
        }
        return columns;
    }

    @Override
    public void write(Writer output) throws IOException {
        CsvWriter writer = new CsvWriter(output, ',');
        writer.setForceQualifier(true);
        if (this.isHeaderLine() && !this.getHeaderFields().isEmpty()) {
            String[] record = new String[this.getHeaderFields().size()];
            for (int i = 0; i < this.getHeaderFields().size(); ++i) {
                record[i] = this.getHeaderFields().get(i);
            }
            writer.writeRecord(record);
        }
        for (Object line : this.getLines()) {
            int numberOfCols = this.getWriter().getNoOfColumns(line);
            if (numberOfCols == 0) {
                throw new IllegalStateException("The number of columns must be greater than 0");
            }
            String[] record = new String[numberOfCols];
            for (int i = 0; i < numberOfCols; ++i) {
                record[i] = this.getWriter().getColumn(line, i);
            }
            writer.writeRecord(record);
        }
    }
}

