/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.GoodCsvDocument;
import uk.ac.warwick.util.csv.NamedValueCSVLineReader;

final class GoodCsvReadingTests {
    GoodCsvReadingTests() {
    }

    @Test
    void parsesData() throws Exception {
        NamedValueCSVLineReader reader = new NamedValueCSVLineReader();
        reader.setHasHeaders(true);
        InputStream is = this.getClass().getResourceAsStream("/csv/nicedocument.csv");
        Assertions.assertNotNull((Object)is);
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        GoodCsvDocument doc = new GoodCsvDocument(null, (CSVLineReader)reader);
        doc.read((Reader)isr);
        List headers = reader.getHeaders();
        List data = reader.getData();
        Assertions.assertEquals((int)3, (int)headers.size());
        Assertions.assertEquals((Object)"$Money\u00a3", headers.get(2));
        Assertions.assertEquals((Object)"\u20ac2.20", ((Map)data.get(2)).get("$Money\u00a3"));
        Assertions.assertEquals((Object)"Man shouting \"Argh!\"", ((Map)data.get(3)).get("Product"));
    }
}

