package uk.ac.warwick.util.csv;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import uk.ac.warwick.util.core.StringUtils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;

import static org.junit.jupiter.api.Assertions.assertEquals;

final class GoodCsvReadingTests {

    // There used to be various encoding tests in here but they were a bit pointless
    // as it was only really testing the behaviour of InputStreamReader.

    @Test
    void parsesData() throws Exception {
        NamedValueCSVLineReader reader = new NamedValueCSVLineReader();
        reader.setHasHeaders(true);

        InputStream is = getClass().getResourceAsStream("/csv/nicedocument.csv"); // UTF-8 encoded file
        Assertions.assertNotNull(is);
        InputStreamReader isr = new InputStreamReader(is, StringUtils.DEFAULT_ENCODING);

        GoodCsvDocument<List<String>> doc = new GoodCsvDocument<List<String>>(null, reader);
        doc.read(isr);

        List<String> headers = reader.getHeaders();
        List<Map<String, String>> data = reader.getData();
        assertEquals(3, headers.size());

        assertEquals("$Money£", headers.get(2));
        assertEquals("€2.20", data.get(2).get("$Money£"));
        assertEquals("Man shouting \"Argh!\"", data.get(3).get("Product"));
    }
}
