/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.csv;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;
import uk.ac.warwick.util.csv.CSVLineReader;
import uk.ac.warwick.util.csv.GoodCsvDocument;
import uk.ac.warwick.util.csv.NamedValueCSVLineReader;

public final class GoodCsvReadingTests
extends TestCase {
    private static final char POUND = '\u00a3';

    public void testNonAsciiCharacters() throws Exception {
        NamedValueCSVLineReader reader = new NamedValueCSVLineReader();
        reader.setHasHeaders(true);
        String lastValue = "\u00a3Mon\u00a3y\u00a3";
        String input = "Product,Type," + lastValue;
        GoodCsvDocument doc = new GoodCsvDocument(null, (CSVLineReader)reader);
        doc.read((Reader)new StringReader(input));
        List headers = reader.getHeaders();
        GoodCsvReadingTests.assertEquals((int)3, (int)headers.size());
        GoodCsvReadingTests.assertEquals((String)lastValue, (String)((String)headers.get(2)));
    }

    public void testNonAsciiCharactersFromAFile() throws Exception {
        NamedValueCSVLineReader reader = new NamedValueCSVLineReader();
        reader.setHasHeaders(true);
        String lastValue = "\u00a3Mon\u00a3y\u00a3";
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/csvWithPound.csv");
        GoodCsvDocument doc = new GoodCsvDocument(null, (CSVLineReader)reader);
        doc.read((Reader)new InputStreamReader(stream, "UTF-8"));
        List headers = reader.getHeaders();
        GoodCsvReadingTests.assertEquals((int)3, (int)headers.size());
        GoodCsvReadingTests.assertEquals((String)lastValue, (String)((String)headers.get(2)));
    }

    public void testNonAsciiCharactersFromAFileWithWrongCharset() throws Exception {
        NamedValueCSVLineReader reader = new NamedValueCSVLineReader();
        reader.setHasHeaders(true);
        String lastValue = "\u00a3Mon\u00a3y\u00a3";
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("/csvWithPound.csv");
        GoodCsvDocument doc = new GoodCsvDocument(null, (CSVLineReader)reader);
        doc.read((Reader)new InputStreamReader(stream, "utf-8"));
        List headers = reader.getHeaders();
        GoodCsvReadingTests.assertEquals((int)3, (int)headers.size());
        GoodCsvReadingTests.assertFalse((boolean)lastValue.equals(headers.get(2)));
    }
}

