/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import uk.ac.warwick.util.convert.ConversionMedia;
import uk.ac.warwick.util.convert.ConversionStatus;
import uk.ac.warwick.util.web.Uri;

public interface ConversionService {
    public ConversionMedia upload(ByteSource var1) throws IOException;

    public ConversionMedia getMediaById(String var1) throws IOException;

    public ConversionStatus convert(ConversionMedia var1, Format var2) throws IOException;

    public ConversionStatus getStatus(String var1) throws IOException;

    public void delete(ConversionMedia var1) throws IOException;

    public Uri getEncodedFileUrl(ConversionStatus var1) throws IOException;

    public Uri getScreenshotUrl(ConversionStatus var1) throws IOException;

    public void processEncodedFile(ConversionStatus var1, Consumer<InputStream> var2) throws IOException;

    public ByteSource getEncodedFile(ConversionStatus var1) throws IOException;

    public void processScreenshot(ConversionStatus var1, Consumer<InputStream> var2) throws IOException;

    public ByteSource getScreenshot(ConversionStatus var1) throws IOException;

    public static enum Format {
        h264("h264-constrain"),
        webm("webm-constrain"),
        jpg("thumbnail-constrain"),
        mp3("mp3");

        private final String profileName;

        private Format(String profileName) {
            this.profileName = profileName;
        }

        public String getProfileName() {
            return this.profileName;
        }
    }
}

