/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert.zencoder;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.warwick.util.convert.ConversionMedia;

class ZencoderConversionMedia
implements ConversionMedia {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ISO_DATE_TIME;
    private int id;
    private String s3Url;
    private ZonedDateTime created;
    private ZonedDateTime updated;
    private ConversionMedia.Status status;
    private Integer width;
    private Integer height;
    private Duration duration;

    ZencoderConversionMedia() {
    }

    public static ZencoderConversionMedia fromTimeout(String id) {
        ZencoderConversionMedia media = new ZencoderConversionMedia();
        media.id = Integer.parseInt(id);
        media.status = ConversionMedia.Status.processing;
        return media;
    }

    public static ZencoderConversionMedia fromJobJSON(JSONObject json) throws JSONException {
        ZencoderConversionMedia media = new ZencoderConversionMedia();
        media.id = json.getInt("id");
        media.created = ZonedDateTime.parse(json.getString("created_at"), DATETIME_FORMAT);
        media.updated = ZonedDateTime.parse(json.getString("updated_at"), DATETIME_FORMAT);
        JSONObject input = json.getJSONObject("input_media_file");
        media.s3Url = input.getString("url");
        switch (input.getString("state")) {
            case "assigning": 
            case "pending": 
            case "queued": 
            case "waiting": 
            case "processing": {
                media.status = ConversionMedia.Status.processing;
                break;
            }
            case "finished": {
                media.status = ConversionMedia.Status.success;
                break;
            }
            case "failed": 
            case "cancelled": {
                media.status = ConversionMedia.Status.fail;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected input state: " + input.getString("state"));
            }
        }
        media.width = input.isNull("width") ? null : Integer.valueOf(input.getInt("width"));
        media.height = input.isNull("height") ? null : Integer.valueOf(input.getInt("height"));
        media.duration = input.isNull("duration_in_ms") ? null : Duration.ofMillis(input.getLong("duration_in_ms"));
        return media;
    }

    @Override
    public String getId() {
        return Integer.toString(this.id);
    }

    @Override
    public String getOriginalFilename() {
        return this.s3Url;
    }

    @Override
    public ZonedDateTime getCreated() {
        return this.created;
    }

    @Override
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    @Override
    public ConversionMedia.Status getStatus() {
        return this.status;
    }

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public Duration getDuration() {
        return this.duration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZencoderConversionMedia that = (ZencoderConversionMedia)o;
        return new EqualsBuilder().append(this.id, that.id).append((Object)this.s3Url, (Object)that.s3Url).append((Object)this.created, (Object)that.created).append((Object)this.updated, (Object)that.updated).append((Object)this.status, (Object)that.status).append((Object)this.width, (Object)that.width).append((Object)this.height, (Object)that.height).append((Object)this.duration, (Object)that.duration).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.s3Url).append((Object)this.created).append((Object)this.updated).append((Object)this.status).append((Object)this.width).append((Object)this.height).append((Object)this.duration).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("s3Url", (Object)this.s3Url).append("created", (Object)this.created).append("updated", (Object)this.updated).append("status", (Object)this.status).append("width", (Object)this.width).append("height", (Object)this.height).append("duration", (Object)this.duration).toString();
    }
}

