/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert.cloudconvert;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import uk.ac.warwick.util.convert.DocumentConversionResult;

public class CloudConvertDocumentConversionResult
implements DocumentConversionResult {
    private final String conversionId;
    private final boolean successful;
    private final String errorMessage;
    private final List<String> urls;

    private CloudConvertDocumentConversionResult(String conversionId, boolean successful, List<String> urls, String errorMessage) {
        this.conversionId = conversionId;
        this.successful = successful;
        this.urls = urls;
        this.errorMessage = errorMessage;
    }

    public static CloudConvertDocumentConversionResult success(String conversionId, List<String> keys) {
        return new CloudConvertDocumentConversionResult(conversionId, true, keys, null);
    }

    public static CloudConvertDocumentConversionResult error(String conversionId, String message) {
        return new CloudConvertDocumentConversionResult(conversionId, false, Collections.emptyList(), message);
    }

    @Override
    public String getConversionId() {
        return this.conversionId;
    }

    @Override
    public boolean isSuccessful() {
        return this.successful;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public List<String> getConvertedFileIds() {
        return this.urls;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CloudConvertDocumentConversionResult that = (CloudConvertDocumentConversionResult)o;
        return new EqualsBuilder().append(this.successful, that.successful).append((Object)this.conversionId, (Object)that.conversionId).append((Object)this.errorMessage, (Object)that.errorMessage).append(this.urls, that.urls).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.conversionId).append(this.successful).append((Object)this.errorMessage).append(this.urls).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("conversionId", (Object)this.conversionId).append("successful", this.successful).append("errorMessage", (Object)this.errorMessage).append("s3Keys", this.urls).toString();
    }
}

