/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert.zencoder;

import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.warwick.util.convert.ConversionStatus;
import uk.ac.warwick.util.web.Uri;

class ZencoderConversionStatus
implements ConversionStatus {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ISO_DATE_TIME;
    private int id;
    private ConversionStatus.Status status;
    private List<String> files;
    private List<String> screenshots;
    private ZonedDateTime created;
    private ZonedDateTime updated;
    private Integer progress;

    ZencoderConversionStatus() {
    }

    public static ZencoderConversionStatus fromProgressJSON(int id, JSONObject json) throws JSONException {
        ZencoderConversionStatus status = new ZencoderConversionStatus();
        status.id = id;
        switch (json.getString("state")) {
            case "assigning": 
            case "pending": 
            case "queued": 
            case "waiting": 
            case "processing": {
                status.status = ConversionStatus.Status.processing;
                break;
            }
            case "finished": {
                status.status = ConversionStatus.Status.success;
                break;
            }
            case "failed": 
            case "cancelled": {
                status.status = ConversionStatus.Status.fail;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected input state: " + json.getString("state"));
            }
        }
        status.files = Collections.emptyList();
        status.screenshots = Collections.emptyList();
        status.progress = json.isNull("progress") ? null : Integer.valueOf((int)Math.ceil(json.getDouble("progress")));
        return status;
    }

    public static ZencoderConversionStatus fromCompletedJobJSON(JSONObject json) throws JSONException {
        ZencoderConversionStatus status = new ZencoderConversionStatus();
        status.id = json.getInt("id");
        status.created = ZonedDateTime.parse(json.getString("created_at"), DATETIME_FORMAT);
        status.updated = ZonedDateTime.parse(json.getString("updated_at"), DATETIME_FORMAT);
        status.progress = 100;
        switch (json.getString("state")) {
            case "finished": {
                status.status = ConversionStatus.Status.success;
                break;
            }
            case "failed": 
            case "cancelled": {
                status.status = ConversionStatus.Status.fail;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected input state: " + json.getString("state"));
            }
        }
        ImmutableList.Builder files = ImmutableList.builder();
        JSONArray jsonFiles = json.getJSONArray("output_media_files");
        for (int i = 0; i < jsonFiles.length(); ++i) {
            files.add((Object)Uri.parse((String)jsonFiles.getJSONObject(i).getString("url")).getPath().substring(1));
        }
        status.files = files.build();
        ImmutableList.Builder screenshots = ImmutableList.builder();
        JSONArray jsonScreenshots = json.getJSONArray("thumbnails");
        for (int i = 0; i < jsonScreenshots.length(); ++i) {
            screenshots.add((Object)Uri.parse((String)jsonScreenshots.getJSONObject(i).getString("url")).getPath().substring(1));
        }
        status.screenshots = screenshots.build();
        return status;
    }

    @Override
    public String getId() {
        return Integer.toString(this.id);
    }

    @Override
    public ConversionStatus.Status getStatus() {
        return this.status;
    }

    @Override
    public List<String> getFiles() {
        return this.files;
    }

    @Override
    public List<String> getScreenshots() {
        return this.screenshots;
    }

    @Override
    public ZonedDateTime getCreated() {
        return this.created;
    }

    @Override
    public ZonedDateTime getUpdated() {
        return this.updated;
    }

    @Override
    public Integer getProgress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZencoderConversionStatus that = (ZencoderConversionStatus)o;
        return new EqualsBuilder().append(this.id, that.id).append((Object)this.status, (Object)that.status).append(this.files, that.files).append(this.screenshots, that.screenshots).append((Object)this.created, (Object)that.created).append((Object)this.updated, (Object)that.updated).append((Object)this.progress, (Object)that.progress).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.status).append(this.files).append(this.screenshots).append((Object)this.created).append((Object)this.updated).append((Object)this.progress).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", this.id).append("status", (Object)this.status).append("files", this.files).append("screenshots", this.screenshots).append("created", (Object)this.created).append("updated", (Object)this.updated).append("progress", (Object)this.progress).toString();
    }
}

