/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.convert.zencoder;

import com.amazonaws.HttpMethod;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.ProxySelector;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import uk.ac.warwick.util.convert.ConversionException;
import uk.ac.warwick.util.convert.ConversionMedia;
import uk.ac.warwick.util.convert.ConversionService;
import uk.ac.warwick.util.convert.ConversionStatus;
import uk.ac.warwick.util.convert.S3ByteSource;
import uk.ac.warwick.util.convert.zencoder.ZencoderConversionMedia;
import uk.ac.warwick.util.convert.zencoder.ZencoderConversionStatus;
import uk.ac.warwick.util.core.DateTimeUtils;
import uk.ac.warwick.util.web.Uri;

public class ZencoderConversionService
implements ConversionService,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZencoderConversionService.class);
    private static final String API_HOST = "app.zencoder.com";
    private static final String API_VERSION = "v2";
    private final CloseableHttpClient httpClient;
    private final String apiKey;
    private final AmazonS3 s3;
    private final TransferManager transferManager;
    private final String bucketName;

    public ZencoderConversionService(String zcApiKey, String awsAccessKey, String awsSecretKey, String awsBucketName) {
        this.apiKey = zcApiKey;
        this.s3 = new AmazonS3Client((AWSCredentials)new BasicAWSCredentials(awsAccessKey, awsSecretKey));
        this.bucketName = awsBucketName;
        this.transferManager = TransferManagerBuilder.standard().withS3Client(this.s3).build();
        this.httpClient = HttpClientBuilder.create().setDefaultConnectionConfig(ConnectionConfig.custom().setBufferSize(8192).setCharset(StandardCharsets.UTF_8).build()).setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setExpectContinueEnabled(true).setCircularRedirectsAllowed(true).setRedirectsEnabled(true).setMaxRedirects(10).build()).setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build()).setMaxConnPerRoute(5).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(1, false)).setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(ProxySelector.getDefault())).build();
    }

    @Override
    public ConversionMedia upload(ByteSource source) throws IOException {
        String uploadId = UUID.randomUUID().toString();
        final String key = "inputs/" + uploadId;
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(source.size());
        metadata.setContentDisposition(uploadId);
        LOGGER.info("[Upload " + uploadId + "] Uploading " + source + " to Amazon S3: s3://" + this.bucketName + "/" + key);
        Upload upload = this.transferManager.upload(this.bucketName, key, source.openStream(), metadata);
        try {
            upload.waitForCompletion();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        HttpPost request = new HttpPost("https://app.zencoder.com/api/v2/jobs");
        request.setHeader("Zencoder-Api-Key", this.apiKey);
        try {
            request.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(new JSONObject(){
                {
                    this.put("input", "s3://" + ZencoderConversionService.this.bucketName + "/" + key);
                    this.put("outputs", new JSONObject(){
                        {
                            this.put("type", "transfer-only");
                        }
                    });
                }
            }.toString()).build());
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        LOGGER.info("[Upload " + uploadId + "] Creating transfer-only job");
        int jobId = (Integer)this.httpClient.execute((HttpUriRequest)request, response -> {
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new ConversionException("Invalid status code " + response.getStatusLine().getStatusCode() + " returned from Zencoder: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            try {
                String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[Upload " + uploadId + "] Response received for job creation " + responseContents);
                }
                JSONObject json = new JSONObject(responseContents);
                int id = json.getInt("id");
                int outputId = json.getJSONArray("outputs").getJSONObject(0).getInt("id");
                LOGGER.info("[Upload " + uploadId + "] Job created, job ID " + id + "; output ID " + outputId);
                return id;
            }
            catch (JSONException e) {
                throw new ConversionException("Invalid JSON returned from Zencoder", e);
            }
        });
        ConversionMedia media = this.getMediaById(Integer.toString(jobId));
        try {
            while (media.getStatus() != ConversionMedia.Status.success && media.getStatus() != ConversionMedia.Status.fail) {
                Thread.sleep(1000L);
                media = this.getMediaById(Integer.toString(jobId));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return media;
    }

    private JSONObject getJob(String id) throws IOException {
        HttpGet request = new HttpGet("https://app.zencoder.com/api/v2/jobs/" + id + ".json?api_key=" + this.apiKey);
        return (JSONObject)this.httpClient.execute((HttpUriRequest)request, response -> {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ConversionException("Invalid status code " + response.getStatusLine().getStatusCode() + " returned from Zencoder: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            try {
                String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[" + id + "] Response received for retrieval of job information: " + responseContents);
                }
                return new JSONObject(responseContents).getJSONObject("job");
            }
            catch (JSONException e) {
                throw new ConversionException("Invalid JSON returned from Zencoder", e);
            }
        });
    }

    @Override
    public ConversionMedia getMediaById(String id) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + id + "] Requesting job information");
        }
        try {
            return ZencoderConversionMedia.fromJobJSON(this.getJob(id));
        }
        catch (JSONException e) {
            throw new ConversionException("Invalid JSON returned from Zencoder", e);
        }
        catch (SocketTimeoutException e) {
            return ZencoderConversionMedia.fromTimeout(id);
        }
    }

    @Override
    public ConversionStatus convert(ConversionMedia media, final ConversionService.Format format) throws IOException {
        final String s3Url = media.getOriginalFilename();
        LOGGER.info("[" + media.getId() + "] Creating encoding job to " + (Object)((Object)format) + " for " + s3Url);
        HttpPost request = new HttpPost("https://app.zencoder.com/api/v2/jobs");
        request.setHeader("Zencoder-Api-Key", this.apiKey);
        try {
            request.setEntity(EntityBuilder.create().setContentType(ContentType.APPLICATION_JSON).setText(new JSONObject(){
                {
                    this.put("input", s3Url);
                    this.put("outputs", new JSONArray(){
                        {
                            this.put(new JSONObject(){
                                {
                                    this.put("base_url", "s3://" + ZencoderConversionService.this.bucketName + "/output/");
                                    switch (format) {
                                        case h264: 
                                        case jpg: {
                                            this.put("format", "mp4");
                                            break;
                                        }
                                        case webm: {
                                            this.put("format", "webm");
                                            break;
                                        }
                                        case mp3: {
                                            this.put("format", "mp3");
                                            this.put("skip_video", true);
                                            break;
                                        }
                                        default: {
                                            throw new IllegalStateException("Invalid format: " + (Object)((Object)format));
                                        }
                                    }
                                    if (format != ConversionService.Format.mp3) {
                                        this.put("thumbnails", new JSONObject(){
                                            {
                                                this.put("format", "jpg");
                                                this.put("number", 1);
                                                this.put("base_url", "s3://" + ZencoderConversionService.this.bucketName + "/output/");
                                            }
                                        });
                                    }
                                }
                            });
                        }
                    });
                }
            }.toString()).build());
        }
        catch (JSONException e) {
            throw new IllegalStateException(e);
        }
        int jobId = (Integer)this.httpClient.execute((HttpUriRequest)request, response -> {
            if (response.getStatusLine().getStatusCode() != 201) {
                throw new ConversionException("Invalid status code " + response.getStatusLine().getStatusCode() + " returned from Zencoder: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            try {
                String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[" + media.getId() + "] Response received for job creation " + responseContents);
                }
                JSONObject json = new JSONObject(responseContents);
                int id = json.getInt("id");
                LOGGER.info("[" + media.getId() + "] Job created, job ID " + id);
                return id;
            }
            catch (JSONException e) {
                throw new ConversionException("Invalid JSON returned from Zencoder", e);
            }
        });
        return this.getStatus(Integer.toString(jobId));
    }

    @Override
    public ConversionStatus getStatus(String id) throws IOException {
        HttpGet request;
        ConversionStatus status;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + id + "] Requesting job progress information");
        }
        if ((status = (ConversionStatus)this.httpClient.execute((HttpUriRequest)(request = new HttpGet("https://app.zencoder.com/api/v2/jobs/" + id + "/progress.json?api_key=" + this.apiKey)), response -> {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ConversionException("Invalid status code " + response.getStatusLine().getStatusCode() + " returned from Zencoder: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            try {
                String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("[" + id + "] Response received for retrieval of job progress: " + responseContents);
                }
                return ZencoderConversionStatus.fromProgressJSON(Integer.parseInt(id), new JSONObject(responseContents));
            }
            catch (JSONException e) {
                throw new ConversionException("Invalid JSON returned from Zencoder", e);
            }
        })).getStatus() == ConversionStatus.Status.processing) {
            return status;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("[" + id + "] Job is in terminal state " + (Object)((Object)status.getStatus()) + ", returning full job status");
        }
        try {
            return ZencoderConversionStatus.fromCompletedJobJSON(this.getJob(id));
        }
        catch (JSONException e) {
            throw new ConversionException("Invalid JSON returned from Zencoder", e);
        }
    }

    @Override
    public void delete(ConversionMedia media) throws IOException {
        this.s3.deleteObject(this.bucketName, Uri.parse((String)media.getOriginalFilename()).getPath().substring(1));
    }

    private Uri generateS3PrivateUrl(String objectKey) {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.bucketName, objectKey);
        request.setMethod(HttpMethod.GET);
        request.setExpiration(Date.from(Instant.now(DateTimeUtils.CLOCK_IMPLEMENTATION).plus(1L, ChronoUnit.HOURS)));
        return Uri.fromJavaUrl((URL)this.s3.generatePresignedUrl(request));
    }

    @Override
    public Uri getEncodedFileUrl(ConversionStatus status) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getFiles().isEmpty()) {
            throw new ConversionException("Can only get encoded file once encoding is successful");
        }
        return this.generateS3PrivateUrl(status.getFiles().iterator().next());
    }

    @Override
    public Uri getScreenshotUrl(ConversionStatus status) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getScreenshots().isEmpty()) {
            throw new ConversionException("Conversion not successful or no screenshots generated");
        }
        return this.generateS3PrivateUrl(status.getScreenshots().iterator().next());
    }

    private void handleS3Object(String objectKey, Consumer<InputStream> consumer) throws IOException {
        S3ByteSource source = this.getS3ByteSource(objectKey);
        try (InputStream is = source.openBufferedStream();){
            consumer.accept(is);
        }
    }

    private S3ByteSource getS3ByteSource(String objectKey) {
        return new S3ByteSource(this.s3, this.bucketName, objectKey);
    }

    @Override
    public void processEncodedFile(ConversionStatus status, Consumer<InputStream> consumer) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getFiles().isEmpty()) {
            throw new ConversionException("Can only get encoded file once encoding is successful");
        }
        this.handleS3Object(status.getFiles().iterator().next(), consumer);
    }

    @Override
    public void processScreenshot(ConversionStatus status, Consumer<InputStream> consumer) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getScreenshots().isEmpty()) {
            throw new ConversionException("Conversion not successful or no screenshots generated");
        }
        this.handleS3Object(status.getScreenshots().iterator().next(), consumer);
    }

    @Override
    public ByteSource getEncodedFile(ConversionStatus status) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getFiles().isEmpty()) {
            throw new ConversionException("Can only get encoded file once encoding is successful");
        }
        return this.getS3ByteSource(status.getFiles().iterator().next());
    }

    @Override
    public ByteSource getScreenshot(ConversionStatus status) throws IOException {
        if (status.getStatus() != ConversionStatus.Status.success || status.getScreenshots().isEmpty()) {
            throw new ConversionException("Conversion not successful or no screenshots generated");
        }
        return this.getS3ByteSource(status.getScreenshots().iterator().next());
    }

    public int getRemainingMinutes() throws IOException {
        HttpGet request = new HttpGet("https://app.zencoder.com/api/v2/account?api_key=" + this.apiKey);
        return (Integer)this.httpClient.execute((HttpUriRequest)request, response -> {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IllegalStateException("Unexpected response code " + response.getStatusLine().getStatusCode() + " returned from Zencoder: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            try {
                String responseContents = EntityUtils.toString((HttpEntity)response.getEntity());
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Response received for request to get account information: " + responseContents);
                }
                JSONObject json = new JSONObject(responseContents);
                int minutesUsed = json.getInt("minutes_used");
                int includedMinutes = json.getInt("minutes_included");
                return includedMinutes - minutesUsed;
            }
            catch (JSONException e) {
                throw new IllegalStateException("Invalid JSON returned from CloudConvert", e);
            }
        });
    }

    public void destroy() throws Exception {
        this.httpClient.close();
        this.transferManager.shutdownNow();
    }
}

