/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.AudioMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.AviMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.FlvMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlTransformer;
import uk.ac.warwick.util.content.texttransformers.media.MetacafeMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.PreziMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.QuickTimeMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.StandardFlashMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.VimeoMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.YouTubeMediaUrlHandler;

public class ListOfUrlsForHandlingTest
extends TestCase {
    public void testNothingDies() throws IOException {
        HashMap<String, Object> handlers = new HashMap<String, Object>();
        handlers.put("audio", new AudioMediaUrlHandler("", ""));
        handlers.put("youtube", new YouTubeMediaUrlHandler());
        handlers.put("quicktime", new QuickTimeMediaUrlHandler(""));
        handlers.put("avi", new AviMediaUrlHandler(""));
        handlers.put("flv", new FlvMediaUrlHandler("", ""));
        handlers.put("flash", new StandardFlashMediaUrlHandler());
        handlers.put("metacafe", new MetacafeMediaUrlHandler());
        handlers.put("vimeo", new VimeoMediaUrlHandler());
        handlers.put("prezi", new PreziMediaUrlHandler());
        MediaUrlTransformer transformer = new MediaUrlTransformer(handlers, "");
        for (String tag : this.readResourceToLines("/mediaTagList.txt")) {
            transformer.apply(new MutableContent(null, tag));
        }
    }

    private List<String> readResourceToLines(String file) throws IOException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(file);
        ArrayList<String> result = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        if (is == null) {
            throw new FileNotFoundException("resource not found: " + file);
        }
        InputStreamReader reader = new InputStreamReader(is);
        int c = reader.read();
        do {
            if (c == 10) {
                result.add(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            buf.append((char)c);
        } while ((c = reader.read()) != -1);
        return result;
    }
}

