/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import junit.framework.TestCase;
import uk.ac.warwick.util.content.texttransformers.AttributeStringParser;

public class AttributeStringParserTest
extends TestCase {
    public void testSingleQuotes() {
        String input = " param-1='value 1'  param2='value 2' ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value 1", (String)parser.getValue("param-1"));
        AttributeStringParserTest.assertEquals((String)"value 2", (String)parser.getValue("param2"));
    }

    public void testDoubleQuotes() {
        String input = " param1=\"value 1\"  param2=\"value 2\" ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value 1", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value 2", (String)parser.getValue("param2"));
    }

    public void testNoQuotes() {
        String input = " param1=value1  param2=value2 ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value1", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value2", (String)parser.getValue("param2"));
    }

    public void testNoQuotesNbsp() {
        String input = " param1=value1&nbsp; param2=value2 ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value1", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value2", (String)parser.getValue("param2"));
    }

    public void testEscapedQuotes() {
        String input = "param1=&#8217;value1&#8217; param2=&#8221;value2&#8221; param3=&quot;value3&quot;";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value1", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value2", (String)parser.getValue("param2"));
        AttributeStringParserTest.assertEquals((String)"value3", (String)parser.getValue("param3"));
    }

    public void testBackslashEscaping() {
        String input = "allowed2=\"The \\\"Magic\\\" tag\" allowed1='It\\'s escaped!'";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"It's escaped!", (String)parser.getValue("allowed1"));
        AttributeStringParserTest.assertEquals((String)"The \"Magic\" tag", (String)parser.getValue("allowed2"));
    }

    public void testBackslashesForDifferentQuotes() {
        String input = "allowed2=\"Bob\\'s Cobs\"";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"Bob\\'s Cobs", (String)parser.getValue("allowed2"));
    }

    public void testDoubleQuotesAllowedInSingleQuotes() {
        String input = " param1='Say \"Hello\"'  param2=value2 ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"Say \"Hello\"", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value2", (String)parser.getValue("param2"));
    }

    public void testSingleQuotesAllowedInDoubleQuotes() {
        String input = " param1=\"Bill's\"  param2=value2 ";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"Bill's", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)"value2", (String)parser.getValue("param2"));
    }

    public void testWhitespaceEqualsNoException() {
        String input = " param1=value1 param2= value2 param3=value3";
        AttributeStringParser parser = new AttributeStringParser(input);
        AttributeStringParserTest.assertEquals((String)"value1", (String)parser.getValue("param1"));
        AttributeStringParserTest.assertEquals((String)" value2", (String)parser.getValue("param2"));
        AttributeStringParserTest.assertEquals((String)"value3", (String)parser.getValue("param3"));
    }
}

