/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.freemarker;

import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.warwick.util.JavaVersion;
import uk.ac.warwick.util.content.freemarker.DateTimeFreemarkerObjectWrapper;

public final class DateTimeFreemarkerObjectWrapperTest {
    private TimeZone defaultTz;
    private Locale defaultLocale;
    private String dateSeparator = JavaVersion.isJava9OrNewer() ? "at " : "";

    @Before
    public void setUp() throws Exception {
        this.defaultTz = TimeZone.getDefault();
        this.defaultLocale = Locale.getDefault();
        TimeZone.setDefault(TimeZone.getTimeZone("Europe/London"));
        Locale.setDefault(Locale.UK);
    }

    @After
    public void tearDown() {
        TimeZone.setDefault(this.defaultTz);
        Locale.setDefault(this.defaultLocale);
    }

    @Test
    public void jsr310JavaTimeWrapping() throws Exception {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_21);
        configuration.setClassForTemplateLoading(this.getClass(), "");
        configuration.setObjectWrapper((ObjectWrapper)new DateTimeFreemarkerObjectWrapper());
        Template template = configuration.getTemplate("datetime-test.ftl");
        HashMap<String, Object> rootMap = new HashMap<String, Object>();
        rootMap.put("greeting", "hello");
        StringWriter out = new StringWriter();
        rootMap.put("d", new Date(1234567890000L));
        template.process(rootMap, (Writer)out);
        Assert.assertEquals((Object)("start;13 February 2009 " + this.dateSeparator + "23:31:30 GMT;end"), (Object)out.toString());
        out = new StringWriter();
        rootMap.put("d", Instant.ofEpochMilli(1234567890000L));
        template.process(rootMap, (Writer)out);
        Assert.assertEquals((Object)("start;13 February 2009 " + this.dateSeparator + "23:31:30 GMT;end"), (Object)out.toString());
        out = new StringWriter();
        ZonedDateTime dateTime = LocalDateTime.of(2009, Month.JULY, 1, 1, 2, 3, 4).atZone(ZoneId.of("Europe/London"));
        Assert.assertEquals((Object)"Europe/London", (Object)dateTime.getZone().getId());
        rootMap.put("d", dateTime);
        template.process(rootMap, (Writer)out);
        if (JavaVersion.isJava9OrNewer()) {
            Assert.assertEquals((Object)"start;1 July 2009 at 01:02:03 BST;end", (Object)out.toString());
        } else {
            Assert.assertEquals((Object)"start;01 July 2009 01:02:03 BST;end", (Object)out.toString());
        }
    }

    @Test
    public void jsr310ToDateConversion() {
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
        ZonedDateTime dateTime = LocalDateTime.of(2009, Month.FEBRUARY, 13, 23, 31, 30, 0).atZone(ZoneId.of("Europe/London"));
        Assert.assertEquals((Object)"Europe/London", (Object)dateTime.getZone().getId());
        Assert.assertThat((Object)formatter.format(dateTime), (Matcher)Matchers.containsString((String)"13 February 2009"));
        Assert.assertEquals((long)1234567890000L, (long)dateTime.toInstant().toEpochMilli());
        Date date = Date.from(dateTime.toInstant());
        Assert.assertEquals((long)1234567890000L, (long)date.getTime());
        dateTime = LocalDateTime.of(2009, Month.JULY, 13, 23, 31, 30, 0).atZone(ZoneId.of("Europe/London"));
        Assert.assertEquals((Object)"Europe/London", (Object)dateTime.getZone().getId());
        Assert.assertThat((Object)formatter.format(dateTime), (Matcher)Matchers.containsString((String)"13 July 2009"));
        Assert.assertEquals((long)1247524290000L, (long)dateTime.toInstant().toEpochMilli());
        date = Date.from(dateTime.toInstant());
        Assert.assertEquals((long)1247524290000L, (long)date.getTime());
    }
}

