/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.HashMap;
import java.util.Map;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.AbstractExtensionMatchingMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.AbstractMetadataAwareMediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;

public final class QuickTimeMediaUrlHandler
extends AbstractMetadataAwareMediaUrlHandler {
    private final String defaultPreviewImageLocation;
    private MediaUrlHandler delegate = new AbstractExtensionMatchingMediaUrlHandler(){

        @Override
        protected String[] getSupportedExtensions() {
            return new String[]{"mov", "mpg", "mpeg", "mpe"};
        }

        @Override
        public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
            throw new UnsupportedOperationException();
        }
    };

    public QuickTimeMediaUrlHandler(String theDefaultPreviewImage) {
        this.defaultPreviewImageLocation = theDefaultPreviewImage;
        if (this.defaultPreviewImageLocation == null) {
            throw new IllegalStateException("Default preview image location must be set");
        }
    }

    @Override
    public boolean recognises(String url) {
        return this.delegate.recognises(url);
    }

    @Override
    public String getHtmlInner(String url, Map<String, Object> parameters) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        model.putAll(parameters);
        if (!parameters.containsKey("previewimage")) {
            model.put("previewimage", this.defaultPreviewImageLocation);
        }
        return this.renderTemplate("media/quicktime.ftl", model);
    }
}

