/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.textile2.Textile2;
import uk.ac.warwick.util.content.textile2.TransformationOptions;
import uk.ac.warwick.util.content.texttransformers.media.AbstractExtensionMatchingMediaUrlHandler;
import uk.ac.warwick.util.core.StringUtils;
import uk.ac.warwick.util.core.spring.FileUtils;

public final class AudioMediaUrlHandler
extends AbstractExtensionMatchingMediaUrlHandler {
    private static final Pattern NUMBERS = Pattern.compile("[0-9]+");
    private final String playerLocation;
    private final String alternatePlayerLocation;
    private final EnumSet<TransformationOptions> options;
    private Map<String, String> extensionMimeMap;

    public AudioMediaUrlHandler(String wimpyPlayerLocation, String onePixelOutPlayerLocation) {
        this(wimpyPlayerLocation, onePixelOutPlayerLocation, Textile2.DEFAULT_OPTIONS);
    }

    public AudioMediaUrlHandler(String wimpyPlayerLocation, String onePixelOutPlayerLocation, Set<TransformationOptions> options) {
        this(wimpyPlayerLocation, onePixelOutPlayerLocation, EnumSet.copyOf(options));
    }

    public AudioMediaUrlHandler(String wimpyPlayerLocation, String onePixelOutPlayerLocation, EnumSet<TransformationOptions> options) {
        this.playerLocation = wimpyPlayerLocation;
        this.alternatePlayerLocation = onePixelOutPlayerLocation;
        this.options = options;
        if (this.playerLocation == null && this.alternatePlayerLocation == null) {
            throw new IllegalStateException("Either Wimpy player location or one pixel out player location must be set");
        }
        if (options.contains((Object)TransformationOptions.alwaysUseAlternativeMp3Player) && this.alternatePlayerLocation == null) {
            throw new IllegalStateException("Must set one-pixel-out player location, because alwaysUseAlternativeMp3Player option has been set");
        }
        this.extensionMimeMap = new HashMap<String, String>();
        this.extensionMimeMap.put("mp3", "audio/mpeg");
        this.extensionMimeMap.put("ogg", "audio/ogg");
    }

    @Override
    protected String[] getSupportedExtensions() {
        return new String[]{"mp3"};
    }

    @Override
    public String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.put("url", url);
        String urlExtension = FileUtils.getLowerCaseExtension((String)url);
        model.put("mimeType", this.extensionMimeMap.get(urlExtension));
        if (!this.options.contains((Object)TransformationOptions.alwaysUseAlternativeMp3Player)) {
            model.put("playerLocation", this.playerLocation);
        }
        model.put("useNativeElements", this.options.contains((Object)TransformationOptions.useNativeAudioVideoElements));
        model.put("alternatePlayerLocation", this.alternatePlayerLocation);
        model.putAll(parameters);
        if (this.invalidNumber(model.get("width"))) {
            model.remove("width");
        }
        if (this.invalidNumber(model.get("height"))) {
            model.remove("height");
        }
        if (this.options.contains((Object)TransformationOptions.alwaysUseAlternativeMp3Player)) {
            model.put("altplayer", "true");
        } else if (!StringUtils.hasText((String)this.playerLocation)) {
            model.put("altplayer", "true");
        } else if (!StringUtils.hasText((String)this.alternatePlayerLocation)) {
            model.put("altplayer", "false");
        }
        return this.renderTemplate("media/audio.ftl", model);
    }

    private boolean invalidNumber(Object object) {
        if (object == null) {
            return false;
        }
        return !NUMBERS.matcher((String)object).matches();
    }
}

