/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.texttransformers.media.Attribute;

public final class AttributeStringParser {
    private static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("(?:(\\w+)\\s*=\\s*'([^']*)')|(?:(\\w+)\\s*=\\s*\"([^\"]*)\")|(?:(\\w+)\\s*=\\s*([^\"'\\s]+)\\b)", 34);
    private static final int NAME_GROUP_SINGLE = 1;
    private static final int VALUE_GROUP_SINGLE = 2;
    private static final int NAME_GROUP_DOUBLE = 3;
    private static final int VALUE_GROUP_DOUBLE = 4;
    private static final int NAME_GROUP_NONE = 5;
    private static final int VALUE_GROUP_NONE = 6;
    private final List<Attribute> attributes;

    public AttributeStringParser(String attributesString) {
        Matcher matcher = ATTRIBUTE_PATTERN.matcher(attributesString);
        this.attributes = new ArrayList<Attribute>();
        while (matcher.find()) {
            String value;
            String name;
            if (matcher.group(1) != null) {
                name = matcher.group(1);
                value = matcher.group(2);
            } else if (matcher.group(3) != null) {
                name = matcher.group(3);
                value = matcher.group(4);
            } else {
                name = matcher.group(5);
                value = matcher.group(6);
            }
            this.attributes.add(new Attribute(name, value));
        }
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String getValue(String attributeName) {
        for (Attribute a : this.attributes) {
            if (!attributeName.equals(a.getName())) continue;
            return a.getValue();
        }
        return null;
    }
}

