/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers.media;

import java.util.Map;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.media.MediaUrlHandler;
import uk.ac.warwick.util.content.texttransformers.media.MetadataHandler;

public abstract class AbstractMetadataAwareMediaUrlHandler
extends MediaUrlHandler {
    private MetadataHandler metadataHandler;

    @Override
    public final String getHtml(String url, Map<String, Object> parameters, MutableContent mc) {
        if (parameters.containsKey("width")) {
            parameters.put("width", this.sanitise(parameters.get("width").toString()));
        }
        if (parameters.containsKey("height")) {
            parameters.put("height", this.sanitise(parameters.get("height").toString()));
        }
        if (this.metadataHandler != null) {
            this.metadataHandler.handle(url, parameters, mc);
        }
        if (parameters.containsKey("width")) {
            parameters.put("width", this.sanitise(parameters.get("width").toString()));
        }
        if (parameters.containsKey("height")) {
            parameters.put("height", this.sanitise(parameters.get("height").toString()));
        }
        return this.getHtmlInner(url, parameters);
    }

    private String sanitise(String dimension) {
        if ((dimension = dimension.trim()).equalsIgnoreCase("auto")) {
            return "auto";
        }
        boolean percentage = false;
        if (dimension.endsWith("%")) {
            percentage = true;
            dimension = dimension.substring(0, dimension.length() - 1);
        }
        dimension = dimension.replaceAll("[^0-9]+", "");
        return percentage ? dimension + "%" : dimension;
    }

    abstract String getHtmlInner(String var1, Map<String, Object> var2);

    public MetadataHandler getMetadataHandler() {
        return this.metadataHandler;
    }

    public void setMetadataHandler(MetadataHandler metadataHandler) {
        this.metadataHandler = metadataHandler;
    }
}

