/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;
import uk.ac.warwick.util.content.texttransformers.WrappingTextTransformer;

public final class SquareBracketEscapingTransformer
extends WrappingTextTransformer {
    private static final String OPEN_BRACKET = "&#91;";
    private static final String CLOSE_BRACKET = "&#93;";
    private static final String[] TAGS_TO_ESCAPE = new String[]{"media", "latex", "livesearch"};

    public SquareBracketEscapingTransformer(TextTransformer delegate) {
        super(delegate);
    }

    @Override
    public MutableContent preTransform(MutableContent mc) {
        String text = mc.getContent();
        for (String tag : TAGS_TO_ESCAPE) {
            text = text.replaceAll("\\[" + tag + "(.*?)\\]", OPEN_BRACKET + tag + "$1" + CLOSE_BRACKET).replaceAll("\\[/" + tag + "\\]", "&#91;/" + tag + CLOSE_BRACKET);
        }
        mc.setContent(text);
        return mc;
    }

    @Override
    public MutableContent postTransform(MutableContent mc) {
        String text = mc.getContent();
        text = text.replaceAll(OPEN_BRACKET, "[").replaceAll(CLOSE_BRACKET, "]");
        mc.setContent(text);
        return mc;
    }
}

