/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;
import uk.ac.warwick.util.web.Uri;

public final class RelativeLinkTextTransformer
implements TextTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RelativeLinkTextTransformer.class);
    private static final int MATCH_OUTRO = 3;
    private static final int MATCH_INTRO = 1;
    private static final int MATCH_URL = 2;
    private static final String MATCH_HREF_QUOTES = "(\\shref=\")([^\"]+)(\")";
    private static final String MATCH_HREF_QUOTE = "(\\shref=')([^']+)(')";
    private static final String MATCH_SRC_QUOTES = "(\\ssrc=\")([^\"]+)(\")";
    private static final String MATCH_SRC_QUOTE = "(\\ssrc=')([^']+)(')";
    private static final String MATCH_HREF_NOQUOTES = "(\\shref=)([^\"'\\s>]+)()";
    private static final String MATCH_SRC_NOQUOTES = "(\\ssrc=)([^\"'\\s>]+)()";
    private static final String MATCH_SRCSET_ALL = "(\\ssrcset=['\"])([^\"']+)([\"'])";
    private static final String[] PATTERNS = new String[]{"(\\shref=\")([^\"]+)(\")", "(\\shref=')([^']+)(')", "(\\shref=)([^\"'\\s>]+)()", "(\\ssrc=\")([^\"]+)(\")", "(\\ssrc=')([^']+)(')", "(\\ssrc=)([^\"'\\s>]+)()", "(\\ssrcset=['\"])([^\"']+)([\"'])"};
    private final Uri base;

    public RelativeLinkTextTransformer(Uri theBase) {
        this.base = theBase;
    }

    public RelativeLinkTextTransformer(String theBase) {
        this(Uri.parse((String)theBase));
    }

    public MutableContent apply(MutableContent mc) {
        String text = mc.getContent();
        Pattern noTextile = Pattern.compile("<pre>(.*?)</pre>", 34);
        Matcher matcher = noTextile.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(this.rewriteIgnoreScriptTagContents(text.substring(lastMatch, startIndex)));
            sb.append(text.substring(startIndex, endIndex));
            lastMatch = endIndex;
        }
        sb.append(this.rewriteIgnoreScriptTagContents(text.substring(endIndex)));
        mc.setContent(sb.toString());
        return mc;
    }

    private String rewriteIgnoreScriptTagContents(String text) {
        Pattern noScriptTags = Pattern.compile("<script([^>]*)>(.*?)</script>", 34);
        Matcher matcher = noScriptTags.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(this.doUrlRewriting(text.substring(lastMatch, startIndex)));
            if (matcher.group(1).contains("src=")) {
                sb.append(this.doUrlRewriting("<script" + matcher.group(1) + ">"));
                sb.append(matcher.group(2));
                sb.append("</script>");
            } else {
                sb.append(text.substring(startIndex, endIndex));
            }
            lastMatch = endIndex;
        }
        sb.append(this.doUrlRewriting(text.substring(endIndex)));
        return sb.toString();
    }

    private String rewriteSrcsetAttribute(String text, String pattern) {
        Pattern imagesWithSrcset = Pattern.compile(pattern, 34);
        Matcher matcher = imagesWithSrcset.matcher(text);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            String[] srcSizePairs;
            String matchedSrcSetContents = matcher.group(2);
            ArrayList<String> transformedSrcSizes = new ArrayList<String>();
            for (String srcSizePair : srcSizePairs = matchedSrcSetContents.trim().replaceAll(" +", " ").split("\\s*,\\s*")) {
                String[] extractSrcSize = srcSizePair.split(" ");
                String transformedSrc = this.parseUrl(extractSrcSize[0].trim());
                String extractedSize = extractSrcSize.length > 1 ? " " + extractSrcSize[1].trim() : "";
                transformedSrcSizes.add(transformedSrc + extractedSize);
            }
            String transformedSrc = String.join((CharSequence)", ", transformedSrcSizes);
            matcher.appendReplacement(sb, matcher.group(1) + transformedSrc + matcher.group(3));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public String doUrlRewriting(String text) {
        String result = text;
        for (String pattern : PATTERNS) {
            result = pattern.contains("srcset") ? this.rewriteSrcsetAttribute(result, pattern) : this.doTransform(result, pattern);
        }
        return result;
    }

    private String doTransform(String text, String pattern) {
        Pattern p = Pattern.compile(pattern, 2);
        StringBuffer sb = new StringBuffer();
        Matcher m = p.matcher(text);
        while (m.find()) {
            String url = m.group(2);
            url = this.parseUrl(url).toString();
            m.appendReplacement(sb, m.group(1) + url + m.group(3));
        }
        m.appendTail(sb);
        return sb.toString();
    }

    private String parseUrl(String url) {
        if (Uri.isOpaque((String)url)) {
            return url;
        }
        try {
            return this.base.resolve(Uri.parse((String)url.trim())).toString();
        }
        catch (Uri.UriException e) {
            LOGGER.warn("Couldn't resolve URL " + url, (Throwable)e);
            return url;
        }
    }
}

