/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.Attribute;
import uk.ac.warwick.util.content.texttransformers.AttributeStringParser;
import uk.ac.warwick.util.content.texttransformers.TagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public final class NewWindowLinkTextTransformer
implements TextTransformer {
    public static final String HTML_IMAGE = "<img class='targetBlank' alt='' title='Link opens in a new window' src='/static_war/images/shim.gif' />";

    public MutableContent apply(MutableContent mc) {
        return this.rewriteLinks(mc);
    }

    MutableContent rewriteLinks(MutableContent mc) {
        TagTransformer linkTransformer = new TagTransformer("a", new TextPatternTransformer.Callback(){

            @Override
            public String transform(String input, MutableContent mc) {
                return NewWindowLinkTextTransformer.this.rewriteLink(input);
            }
        }, false);
        return linkTransformer.apply(mc);
    }

    private String rewriteLink(String elementHtml) {
        Matcher matcher = Pattern.compile("^<a (.+)?>(.+)</a>", 34).matcher(elementHtml);
        if (matcher.find()) {
            String attributesString = matcher.group(1);
            AttributeStringParser parser = new AttributeStringParser(attributesString);
            StringBuffer result = new StringBuffer();
            result.append(elementHtml.substring(0, matcher.end(2)));
            if (this.hasNewWindowAttribute(parser.getAttributes())) {
                result.append(HTML_IMAGE);
            }
            result.append(elementHtml.substring(matcher.end(2)));
            return result.toString();
        }
        return elementHtml;
    }

    private boolean hasNewWindowAttribute(List<Attribute> attributes) {
        for (Attribute a : attributes) {
            if (!a.getName().equalsIgnoreCase("target") || !a.getValue().equalsIgnoreCase("_blank") && !a.getValue().equalsIgnoreCase("_new")) continue;
            return true;
        }
        return false;
    }
}

