/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.Map;
import java.util.regex.Matcher;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.AbstractSquareTagTransformer;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;
import uk.ac.warwick.util.core.HtmlUtils;
import uk.ac.warwick.util.core.HttpUtils;

public final class LatexTextTransformer
extends AbstractSquareTagTransformer {
    private final String latexUrl;
    private String[] ALLOWED_PARAMETERS = new String[]{"alt"};

    public LatexTextTransformer(String theLatexUrl) {
        super("latex", true);
        this.latexUrl = theLatexUrl;
    }

    @Override
    protected String[] getAllowedParameters() {
        return this.ALLOWED_PARAMETERS;
    }

    @Override
    protected boolean isTagGeneratesHead() {
        return false;
    }

    @Override
    protected TextPatternTransformer.Callback getCallback() {
        return new TextPatternTransformer.Callback(){

            @Override
            public String transform(String input, MutableContent mc) {
                Matcher matcher = LatexTextTransformer.this.getTagPattern().matcher(input);
                if (!matcher.matches()) {
                    throw new IllegalStateException("Failed to match latex tag, but shouldn't be here if it didn't");
                }
                String contents = LatexTextTransformer.this.getContents(matcher);
                if (contents == null) {
                    return input;
                }
                String urlEncodedLatex = HttpUtils.utf8Encode((String)contents.replaceAll(" ", "~"));
                String htmlEncodedLatex = HtmlUtils.htmlEscape((String)contents);
                Map<String, Object> parameters = LatexTextTransformer.this.getParameters(matcher);
                String altText = htmlEncodedLatex;
                if (parameters.containsKey("alt")) {
                    altText = HtmlUtils.htmlEscape((String)parameters.get("alt").toString());
                }
                return "<notextile><img class=\"latex\" src=\"" + LatexTextTransformer.this.latexUrl + "?" + urlEncodedLatex + "\" alt=\"" + altText + "\"></notextile>";
            }
        };
    }
}

