/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.Attribute;
import uk.ac.warwick.util.content.texttransformers.AttributeStringParser;
import uk.ac.warwick.util.content.texttransformers.TextTransformer;

public final class EmailTagTextTransformer
implements TextTransformer {
    private static final Pattern EMAIL_TAG_PATTERN = Pattern.compile("\\[email(\\s+.+?[^\\\\])?\\](.+?)\\[/email\\]", 2);
    private static final int RANDOM_RESTART_THRESHOLD = 15;
    private static final String[] ALLOWED_PARAMETERS = new String[]{"address"};

    public MutableContent apply(MutableContent mc) {
        String result = mc.getContent();
        if (result.indexOf("[email") != -1) {
            result = this.doTransform(result);
            mc.setContent(result);
        }
        return mc;
    }

    private String doTransform(String text) {
        Pattern noTextile = Pattern.compile("<notextile>(.*?)</notextile>", 34);
        Matcher matcher = noTextile.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        HashMap emails = Maps.newHashMap();
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(this.doEmailTransform(text.substring(lastMatch, startIndex), emails));
            sb.append(text.substring(startIndex, endIndex));
            lastMatch = endIndex;
        }
        sb.append(this.doEmailTransform(text.substring(endIndex), emails));
        String html = sb.toString();
        if (emails.isEmpty()) {
            return html;
        }
        return this.insertScript(html, emails);
    }

    private String doEmailTransform(String text, Map<String, String> emails) {
        Pattern htmlComment = Pattern.compile("<!--(.*?)-->", 34);
        Matcher matcher = htmlComment.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(this.doEmailTransform(text.substring(lastMatch, startIndex), emails, false));
            sb.append(this.doEmailTransform(text.substring(startIndex, endIndex), emails, true));
            lastMatch = endIndex;
        }
        sb.append(this.doEmailTransform(text.substring(endIndex), emails, false));
        return sb.toString();
    }

    private String doEmailTransform(String text, Map<String, String> emails, boolean isComment) {
        Matcher matcher = EMAIL_TAG_PATTERN.matcher(text);
        StringBuilder sb = new StringBuilder();
        int lastMatch = 0;
        int startIndex = 0;
        int endIndex = 0;
        while (matcher.find()) {
            startIndex = matcher.start();
            endIndex = matcher.end();
            sb.append(text.substring(lastMatch, startIndex));
            sb.append(this.replaceWithSpan(text.substring(startIndex, endIndex), emails, matcher, isComment));
            lastMatch = endIndex;
        }
        sb.append(text.substring(endIndex));
        return sb.toString();
    }

    private String insertScript(String originalHtml, Map<String, String> emails) {
        String html = originalHtml;
        String script = "<script type=\"text/javascript\">\nEvent.onDOMReady(function() { " + StringUtils.join(emails.values(), (String)"\n") + "});\n</script>";
        html = !HTMLSTART.matcher(html).find() ? "<html><head>" + script + "</head><body>" + html + "</body></html>" : (!HEADEND.matcher(html).find() ? HTMLSTART.matcher(html).replaceFirst("$1<head>" + Matcher.quoteReplacement(script) + "</head>") : HEADEND.matcher(html).replaceFirst(Matcher.quoteReplacement(script) + "$1"));
        return html;
    }

    private String replaceWithSpan(String input, Map<String, String> emails, Matcher matcher, boolean isComment) {
        int i;
        String email;
        String caption;
        Map<String, Object> parameters = this.getParameters(matcher);
        String contents = this.getContents(matcher);
        if (contents == null) {
            return input;
        }
        if (parameters.containsKey("address")) {
            caption = contents;
            email = (String)parameters.get("address");
        } else {
            contents = contents.replaceAll("\\<[^\\>]+\\>", "");
            caption = contents = contents.replaceAll("\\s+", "");
            email = contents;
        }
        StringBuilder sb = new StringBuilder("<a href=\"mailto:");
        Random r = new Random();
        int randomInt = r.nextInt();
        if (randomInt < 0) {
            randomInt = -randomInt;
        }
        String uniqueId = "email" + randomInt;
        for (i = 0; i < email.length(); ++i) {
            sb.append(this.convertChar(email.charAt(i), r));
        }
        sb.append("\">");
        for (i = 0; i < caption.length(); ++i) {
            sb.append(this.convertChar(caption.charAt(i), r));
        }
        sb.append("</a>");
        String js = this.generateJavascriptCode(sb, r, uniqueId);
        if (!isComment) {
            emails.put(uniqueId, js);
        }
        return this.generateSpanCode(parameters, caption, email, r, uniqueId, isComment);
    }

    private String generateSpanCode(Map<String, Object> parameters, String caption, String email, Random r, String uniqueId, boolean isComment) {
        String modifiedEmail = email.replaceAll("@", " at ");
        modifiedEmail = modifiedEmail.replaceAll("\\.", " dot ");
        if (parameters.containsKey("address")) {
            modifiedEmail = caption + " (" + modifiedEmail + ")";
        }
        StringBuilder spanSb = new StringBuilder();
        if (!isComment) {
            spanSb.append("<span id=\"" + uniqueId + "\">");
        }
        for (int i = 0; i < modifiedEmail.length(); ++i) {
            spanSb.append(this.convertChar(modifiedEmail.charAt(i), r));
        }
        if (!isComment) {
            spanSb.append("</span>");
        }
        return spanSb.toString();
    }

    private String generateJavascriptCode(StringBuilder sb, Random r, String uniqueId) {
        StringBuilder javascriptSb = new StringBuilder("var " + uniqueId + " = '");
        for (int i = 0; i < sb.length(); ++i) {
            char thisChar;
            if (r.nextInt(15) == 0) {
                javascriptSb.append("';\n" + uniqueId + " += '");
            }
            if (Character.toString(thisChar = sb.charAt(i)).equals("/")) {
                javascriptSb.append("\\");
            }
            javascriptSb.append(thisChar);
        }
        javascriptSb.append("';\nif(document.getElementById('" + uniqueId + "')) document.getElementById('" + uniqueId + "').innerHTML = " + uniqueId + ";\n");
        return javascriptSb.toString();
    }

    protected final Map<String, Object> getParameters(Matcher matcher) {
        return this.extractParameters(matcher.group(1));
    }

    protected final Map<String, Object> extractParameters(String string) {
        if (string == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        AttributeStringParser parser = new AttributeStringParser(string);
        List<Attribute> attributes = parser.getAttributes();
        for (Attribute a : attributes) {
            String name = a.getName().toLowerCase();
            for (String allowedParameter : ALLOWED_PARAMETERS) {
                if (!name.equals(allowedParameter)) continue;
                result.put(name, a.getValue());
            }
        }
        return result;
    }

    protected final String getContents(Matcher matcher) {
        return matcher.group(2);
    }

    private String convertChar(char c, Random r) {
        String result;
        switch (r.nextInt(2)) {
            case 0: {
                result = this.convertCharToDecimalEntity(c);
                break;
            }
            case 1: {
                result = this.convertCharToHexadecimalEntity(c);
                break;
            }
            default: {
                result = Character.toString(c);
            }
        }
        return result;
    }

    private String convertCharToDecimalEntity(char c) {
        return "&#" + Integer.toString(c) + ";";
    }

    private String convertCharToHexadecimalEntity(char c) {
        return "&#x" + Integer.toHexString(c) + ";";
    }
}

