/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.warwick.util.content.texttransformers;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.warwick.util.content.MutableContent;
import uk.ac.warwick.util.content.texttransformers.TextPatternTransformer;
import uk.ac.warwick.util.web.Uri;

public final class CssUrlRewriteTransformer
extends TextPatternTransformer {
    private final Uri base;
    private Pattern pattern;

    public CssUrlRewriteTransformer(String theBase) {
        this(Uri.parse((String)theBase));
    }

    public CssUrlRewriteTransformer(Uri theBase) {
        this.base = theBase;
    }

    @Override
    protected TextPatternTransformer.Callback getCallback() {
        return new Handler();
    }

    @Override
    protected boolean isGeneratesHead() {
        return false;
    }

    @Override
    protected Pattern getPattern() {
        if (this.pattern == null) {
            String quote = "([\"']?)";
            String path = "([^\"')]+)";
            String unquote = "\\1";
            this.pattern = Pattern.compile("url\\(" + quote + path + unquote + "\\)", 2);
        }
        return this.pattern;
    }

    private Uri parseUrl(String url) {
        return this.base.resolve(Uri.parse((String)url));
    }

    public class Handler
    implements TextPatternTransformer.Callback {
        @Override
        public String transform(String input, MutableContent mc) {
            Matcher matcher = CssUrlRewriteTransformer.this.getPattern().matcher(input);
            if (matcher.find()) {
                String url = matcher.group(2);
                return "url(" + CssUrlRewriteTransformer.this.parseUrl(url).toString() + ")";
            }
            return input;
        }
    }
}

